/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import org.apache.http.client.config.RequestConfig;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

class TimeoutRequestConfigCallback
implements RestClientBuilder.RequestConfigCallback {
    @Nullable
    private final TimeValue connectTimeout;
    @Nullable
    private final TimeValue socketTimeout;

    TimeoutRequestConfigCallback(@Nullable TimeValue connectTimeout, @Nullable TimeValue socketTimeout) {
        assert (connectTimeout != null || socketTimeout != null) : "pointless to use with defaults";
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    @Nullable
    TimeValue getConnectTimeout() {
        return this.connectTimeout;
    }

    @Nullable
    TimeValue getSocketTimeout() {
        return this.socketTimeout;
    }

    public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
        if (this.connectTimeout != null) {
            requestConfigBuilder.setConnectTimeout((int)this.connectTimeout.millis());
        }
        if (this.socketTimeout != null) {
            requestConfigBuilder.setSocketTimeout((int)this.socketTimeout.millis());
        }
        return requestConfigBuilder;
    }
}

