/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;

final class LogsdbLicenseService {
    static final String MAPPINGS_FEATURE_FAMILY = "mappings";
    static final String CUTOFF_DATE_SYS_PROP_NAME = "es.mapping.synthetic_source_fallback_to_stored_source.cutoff_date_restricted_override";
    private static final Logger LOGGER = LogManager.getLogger(LogsdbLicenseService.class);
    static final long DEFAULT_CUTOFF_DATE = LocalDateTime.of(2025, 2, 4, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli();
    public static final Setting<Boolean> FALLBACK_SETTING = Setting.boolSetting((String)"xpack.mapping.synthetic_source_fallback_to_stored_source", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.OperatorDynamic});
    static final LicensedFeature.Momentary SYNTHETIC_SOURCE_FEATURE = LicensedFeature.momentary((String)"mappings", (String)"synthetic-source", (License.OperationMode)License.OperationMode.ENTERPRISE);
    static final LicensedFeature.Momentary SYNTHETIC_SOURCE_FEATURE_LEGACY = LicensedFeature.momentary((String)"mappings", (String)"synthetic-source-legacy", (License.OperationMode)License.OperationMode.GOLD);
    static final LicensedFeature.Momentary LOGSDB_ROUTING_ON_SORT_FIELDS_FEATURE = LicensedFeature.momentary((String)"mappings", (String)"logsdb-routing-on-sort-fields", (License.OperationMode)License.OperationMode.ENTERPRISE);
    private final long cutoffDate;
    private LicenseService licenseService;
    private XPackLicenseState licenseState;
    private volatile boolean syntheticSourceFallback;

    LogsdbLicenseService(Settings settings) {
        this(settings, System.getProperty(CUTOFF_DATE_SYS_PROP_NAME));
    }

    LogsdbLicenseService(Settings settings, String cutoffDate) {
        this.syntheticSourceFallback = (Boolean)FALLBACK_SETTING.get(settings);
        this.cutoffDate = LogsdbLicenseService.getCutoffDate(cutoffDate);
    }

    public boolean fallbackToStoredSource(boolean isTemplateValidation, boolean legacyLicensedUsageOfSyntheticSourceAllowed) {
        boolean beforeCutoffDate;
        if (this.syntheticSourceFallback) {
            return true;
        }
        XPackLicenseState licenseStateSnapshot = this.licenseState.copyCurrentLicenseState();
        if (LogsdbLicenseService.checkFeature(SYNTHETIC_SOURCE_FEATURE, licenseStateSnapshot, isTemplateValidation)) {
            return false;
        }
        License license = this.licenseService.getLicense();
        if (license == null) {
            return true;
        }
        boolean bl = beforeCutoffDate = license.startDate() <= this.cutoffDate;
        if (legacyLicensedUsageOfSyntheticSourceAllowed && beforeCutoffDate && LogsdbLicenseService.checkFeature(SYNTHETIC_SOURCE_FEATURE_LEGACY, licenseStateSnapshot, isTemplateValidation)) {
            LOGGER.debug("legacy license [{}] is allowed to use synthetic source", (Object)licenseStateSnapshot.getOperationMode().description());
            return false;
        }
        return true;
    }

    public boolean allowLogsdbRoutingOnSortField(boolean isTemplateValidation) {
        return LogsdbLicenseService.checkFeature(LOGSDB_ROUTING_ON_SORT_FIELDS_FEATURE, this.licenseState.copyCurrentLicenseState(), isTemplateValidation);
    }

    private static boolean checkFeature(LicensedFeature.Momentary licensedFeature, XPackLicenseState licenseStateSnapshot, boolean isTemplateValidation) {
        if (isTemplateValidation) {
            return licensedFeature.checkWithoutTracking(licenseStateSnapshot);
        }
        return licensedFeature.check(licenseStateSnapshot);
    }

    void setSyntheticSourceFallback(boolean syntheticSourceFallback) {
        this.syntheticSourceFallback = syntheticSourceFallback;
    }

    void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    void setLicenseState(XPackLicenseState licenseState) {
        this.licenseState = licenseState;
    }

    private static long getCutoffDate(String cutoffDateAsString) {
        if (cutoffDateAsString != null) {
            long cutoffDate = LocalDateTime.parse(cutoffDateAsString).toInstant(ZoneOffset.UTC).toEpochMilli();
            LOGGER.warn("Configuring [{}] is only allowed with explicit approval from Elastic.", (Object)CUTOFF_DATE_SYS_PROP_NAME);
            LOGGER.info("Configuring [{}] to [{}]", (Object)CUTOFF_DATE_SYS_PROP_NAME, (Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(cutoffDate), ZoneOffset.UTC));
            return cutoffDate;
        }
        return DEFAULT_CUTOFF_DATE;
    }
}

