/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.migrate.action.CancelReindexDataStreamAction;

public class CancelReindexDataStreamTransportAction
extends HandledTransportAction<CancelReindexDataStreamAction.Request, AcknowledgedResponse> {
    private final PersistentTasksService persistentTasksService;

    @Inject
    public CancelReindexDataStreamTransportAction(TransportService transportService, ActionFilters actionFilters, PersistentTasksService persistentTasksService) {
        super("indices:admin/data_stream/reindex_cancel", transportService, actionFilters, CancelReindexDataStreamAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.persistentTasksService = persistentTasksService;
    }

    protected void doExecute(Task task, CancelReindexDataStreamAction.Request request, final ActionListener<AcknowledgedResponse> listener) {
        String index = request.getIndex();
        String persistentTaskId = "reindex-data-stream-" + index;
        this.persistentTasksService.sendRemoveRequest(persistentTaskId, TimeValue.MAX_VALUE, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

