/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.scalar.Scalar;

public final class FillAll
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static void fill(double[] data, int first, int limit, int step, double value) {
        for (int i = first; i < limit; i += step) {
            data[i] = value;
        }
    }

    public static void fill(double[] data, int first, int limit, int step, NullaryFunction<?> supplier) {
        for (int i = first; i < limit; i += step) {
            data[i] = supplier.doubleValue();
        }
    }

    public static void fill(float[] data, int first, int limit, int step, float value) {
        for (int i = first; i < limit; i += step) {
            data[i] = value;
        }
    }

    public static void fill(float[] data, int first, int limit, int step, NullaryFunction<?> supplier) {
        for (int i = first; i < limit; i += step) {
            data[i] = supplier.floatValue();
        }
    }

    public static <N extends Comparable<N>> void fill(N[] data, int first, int limit, int step, N value) {
        for (int i = first; i < limit; i += step) {
            data[i] = value;
        }
    }

    public static <N extends Comparable<N>> void fill(N[] data, int first, int limit, int step, NullaryFunction<?> supplier, Scalar.Factory<N> scalar) {
        for (int i = first; i < limit; i += step) {
            data[i] = scalar.cast((Comparable<?>)supplier.invoke());
        }
    }
}

