/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.io.Reader;
import org.ojalgo.data.domain.finance.series.DataFetcher;
import org.ojalgo.netio.ResourceLocator;
import org.ojalgo.type.CalendarDateUnit;

public class IEXTradingFetcher
implements DataFetcher {
    private final ResourceLocator myResourceLocator;
    private final String mySymbol;

    public IEXTradingFetcher(String symbol) {
        this.mySymbol = symbol;
        this.myResourceLocator = new ResourceLocator().host("cloud.iexapis.com").path("/1.0/stock/" + symbol + "/chart/5y").query("format", "csv");
    }

    @Override
    public CalendarDateUnit getResolution() {
        return CalendarDateUnit.DAY;
    }

    @Override
    public Reader getStreamOfCSV() {
        return this.myResourceLocator.getStreamReader();
    }

    @Override
    public String getSymbol() {
        return this.mySymbol;
    }
}

