/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.decomposition.AbstractDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.DiagonalStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

abstract class RawDecomposition
extends AbstractDecomposition<Double> {
    private int myColDim;
    private double[][] myInternalData;
    private RawStore myInternalStore;
    private int myRowDim;

    static RawStore make(int nbRows, int nbCols) {
        return (RawStore)RawStore.FACTORY.make(nbRows, nbCols);
    }

    static final <D extends Access1D<?>> DiagonalStore.Builder<Double, D> makeDiagonal(D mainDiag) {
        return DiagonalStore.builder(RawStore.FACTORY, mainDiag);
    }

    protected RawDecomposition() {
    }

    @Override
    public int getColDim() {
        return this.myColDim;
    }

    @Override
    public int getRowDim() {
        return this.myRowDim;
    }

    protected Primitive64Store allocate(long numberOfRows, long numberOfColumns) {
        return (Primitive64Store)Primitive64Store.FACTORY.make(numberOfRows, numberOfColumns);
    }

    protected boolean checkSymmetry() {
        boolean retVal = this.myRowDim == this.myColDim;
        for (int i = 0; retVal && i < this.myRowDim; ++i) {
            for (int j = 0; retVal && j < i; retVal &= NumberContext.compare(this.myInternalData[i][j], this.myInternalData[j][i]) == 0, ++j) {
            }
        }
        return retVal;
    }

    protected MatrixStore<Double> collect(Access2D.Collectable<Double, ? super DecompositionStore<Double>> source) {
        if (source instanceof MatrixStore) {
            return (MatrixStore)source;
        }
        if (source instanceof Access2D) {
            return Primitive64Store.FACTORY.makeWrapper((Access2D)((Object)source));
        }
        return (MatrixStore)source.collect(Primitive64Store.FACTORY);
    }

    @Override
    protected final FunctionSet<Double> function() {
        return PrimitiveFunction.getSet();
    }

    protected double[][] getInternalData() {
        return this.myInternalData;
    }

    protected RawStore getInternalStore() {
        return this.myInternalStore;
    }

    @Override
    protected final Scalar.Factory<Double> scalar() {
        return PrimitiveScalar.FACTORY;
    }

    protected Access2D.Collectable<Double, ? super PhysicalStore<Double>> wrap(Access2D<?> matrix) {
        return Primitive64Store.FACTORY.makeWrapper(matrix);
    }

    RawStore newRawStore(int m, int n) {
        return (RawStore)RawStore.FACTORY.make(m, n);
    }

    double[][] reset(Structure2D template, boolean transpose) {
        int internalCols;
        this.reset();
        int templateRows = template.getRowDim();
        int templateCols = template.getColDim();
        int internalRows = transpose ? templateCols : templateRows;
        int n = internalCols = transpose ? templateRows : templateCols;
        if (this.myInternalData == null || this.myRowDim != templateRows || this.myColDim != templateCols) {
            this.myInternalStore = (RawStore)RawStore.FACTORY.make(internalRows, internalCols);
            this.myInternalData = this.myInternalStore.data;
            this.myRowDim = templateRows;
            this.myColDim = templateCols;
        }
        return this.myInternalData;
    }

    RawStore wrap(double[][] data) {
        return RawStore.wrap(data);
    }
}

