/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.ojalgo.ProgrammingError;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public class CoordinationSet<N extends Comparable<N>>
extends HashMap<String, CalendarDateSeries<N>> {
    private static final long serialVersionUID = 1L;
    private CalendarDateUnit myResolution = null;

    public CoordinationSet() {
    }

    public CoordinationSet(CalendarDateUnit resolution) {
        this.myResolution = resolution;
    }

    public CoordinationSet(Collection<CalendarDateSeries<N>> seriesCollection) {
        super(seriesCollection.size());
        for (CalendarDateSeries<N> tmpTimeSeries : seriesCollection) {
            this.put(tmpTimeSeries);
        }
    }

    public CoordinationSet(Collection<CalendarDateSeries<N>> seriesCollection, CalendarDateUnit resolution) {
        super(seriesCollection.size());
        this.myResolution = resolution;
        for (CalendarDateSeries<N> tmpTimeSeries : seriesCollection) {
            this.put(tmpTimeSeries);
        }
    }

    public CoordinationSet(int initialCapacity) {
        super(initialCapacity);
    }

    public CoordinationSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CoordinationSet(Map<? extends String, ? extends CalendarDateSeries<N>> members) {
        super(members);
    }

    public void complete() {
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpSeries.complete();
        }
    }

    public CoordinationSet<N> copy() {
        return this.resample(this.getResolution());
    }

    @Override
    public CalendarDateSeries<N> get(Object key) {
        if (key instanceof CalendarDateSeries) {
            return (CalendarDateSeries)super.get(((CalendarDateSeries)key).getName());
        }
        return (CalendarDateSeries)super.get(key.toString());
    }

    public CalendarDateSeries<N> get(String seriesName) {
        return (CalendarDateSeries)super.get(seriesName);
    }

    public List<CalendarDate> getAllCalendarDates() {
        TreeSet retVal = new TreeSet();
        for (CalendarDateSeries tmpSeries : this.values()) {
            retVal.addAll(tmpSeries.keySet());
        }
        return new ArrayList<CalendarDate>(retVal);
    }

    public List<String> getAllSeriesNames() {
        return new ArrayList<String>(this.keySet());
    }

    public CalendarDate getEarliestFirstKey() {
        return (CalendarDate)BasicSeries.findEarliestFirstKey(this.values());
    }

    public CalendarDate getEarliestLastKey() {
        return (CalendarDate)BasicSeries.findEarliestLastKey(this.values());
    }

    public CalendarDate getLatestFirstKey() {
        return (CalendarDate)BasicSeries.findLatestFirstKey(this.values());
    }

    public CalendarDate getLatestLastKey() {
        return (CalendarDate)BasicSeries.findLatestLastKey(this.values());
    }

    public CalendarDateUnit getResolution() {
        if (this.myResolution != null) {
            return this.myResolution;
        }
        CalendarDateUnit retVal = null;
        CalendarDateUnit tmpVal = null;
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpVal = tmpSeries.getResolution();
            if (retVal != null && tmpVal.compareTo(retVal) <= 0) continue;
            retVal = tmpVal;
        }
        return retVal;
    }

    public N getValue(String series, CalendarDate date) {
        return this.get(series).get(date);
    }

    public CoordinationSet<N> prune() {
        CoordinationSet retVal = new CoordinationSet(this.getResolution());
        CalendarDate tmpFirstKey = this.getLatestFirstKey();
        CalendarDate tmpLastKey = this.getEarliestLastKey();
        if (tmpLastKey.compareTo(tmpFirstKey) != -1) {
            for (CalendarDateSeries tmpSeries : this.values()) {
                CalendarDateSeries tmpSubMap = tmpSeries.subMap(tmpFirstKey, true, tmpLastKey, true);
                retVal.put(tmpSubMap);
            }
        }
        CalendarDate tmpEarliestFirstKey = retVal.getEarliestFirstKey();
        CalendarDate tmpLatestFirstKey = retVal.getLatestFirstKey();
        CalendarDate tmpEarliestLastKey = retVal.getEarliestLastKey();
        CalendarDate tmpLatestLastKey = retVal.getLatestLastKey();
        if (tmpEarliestFirstKey == null || !tmpEarliestFirstKey.equals(tmpFirstKey)) {
            throw new ProgrammingError("Something went wrong!");
        }
        if (tmpLatestFirstKey == null || !tmpLatestFirstKey.equals(tmpFirstKey)) {
            throw new ProgrammingError("Something went wrong!");
        }
        if (tmpEarliestLastKey == null || !tmpEarliestLastKey.equals(tmpLastKey)) {
            throw new ProgrammingError("Something went wrong!");
        }
        if (tmpLatestLastKey == null || !tmpLatestLastKey.equals(tmpLastKey)) {
            throw new ProgrammingError("Something went wrong!");
        }
        return retVal;
    }

    public CoordinationSet<N> prune(CalendarDateUnit resolution) {
        CoordinationSet<N> retVal = new CoordinationSet<N>(resolution);
        CalendarDate tmpLatestFirstKey = this.getLatestFirstKey();
        CalendarDate tmpEarliestLastKey = this.getEarliestLastKey();
        for (Map.Entry tmpEntry : this.entrySet()) {
            retVal.put(tmpEntry.getKey(), ((CalendarDateSeries)tmpEntry.getValue()).resample(tmpLatestFirstKey, tmpEarliestLastKey, resolution));
        }
        return retVal;
    }

    public CalendarDateSeries<N> put(CalendarDateSeries<N> series) {
        return this.put(series.getName(), series);
    }

    public CoordinationSet<N> resample(CalendarDateUnit resolution) {
        CoordinationSet<N> retVal = new CoordinationSet<N>(resolution);
        for (Map.Entry tmpEntry : this.entrySet()) {
            retVal.put(tmpEntry.getKey(), ((CalendarDateSeries)tmpEntry.getValue()).resample(resolution));
        }
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder retVal = new StringBuilder(this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()));
        for (CalendarDateSeries tmpSeries : this.values()) {
            retVal.append('\n');
            retVal.append(tmpSeries.toString());
        }
        return retVal.toString();
    }
}

