/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.assembler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.InternalComposite;
import org.elasticsearch.xpack.eql.execution.assembler.Criterion;
import org.elasticsearch.xpack.eql.execution.assembler.SampleQueryRequest;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class SampleCriterion
extends Criterion<SampleQueryRequest> {
    private final List<BucketExtractor> keys;
    private final List<String> keyFields;
    private final SampleQueryRequest firstQuery;
    private final SampleQueryRequest midQuery;
    private final SampleQueryRequest finalQuery;

    public SampleCriterion(SampleQueryRequest firstQuery, SampleQueryRequest midQuery, SampleQueryRequest finalQuery, List<String> keyFields, List<BucketExtractor> keys) {
        super(keys.size());
        this.firstQuery = firstQuery;
        this.midQuery = midQuery;
        this.finalQuery = finalQuery;
        this.keys = keys;
        this.keyFields = keyFields;
    }

    public SampleQueryRequest firstQuery() {
        return this.firstQuery;
    }

    public SampleQueryRequest midQuery() {
        return this.midQuery;
    }

    public SampleQueryRequest finalQuery() {
        return this.finalQuery;
    }

    public List<Map<String, Object>> keys(List<InternalComposite.InternalBucket> buckets) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            values.add(this.key(bucket));
        }
        return values;
    }

    public List<List<Object>> keyValues(List<InternalComposite.InternalBucket> buckets) {
        List<Map<String, Object>> keys = this.keys(buckets);
        ArrayList<List<Object>> compositeKeyValues = new ArrayList<List<Object>>(buckets.size());
        for (Map<String, Object> key : keys) {
            ArrayList<Object> values = new ArrayList<Object>(this.keySize());
            for (String keyField : this.keyFields) {
                values.add(key.get(keyField));
            }
            compositeKeyValues.add(values);
        }
        return compositeKeyValues;
    }

    private Map<String, Object> key(MultiBucketsAggregation.Bucket bucket) {
        HashMap<String, Object> key = new HashMap<String, Object>(CollectionUtils.mapSize((int)this.keySize()));
        for (int i = 0; i < this.keySize(); ++i) {
            key.put(this.keyFields.get(i), this.keys.get(i).extract(bucket));
        }
        return key;
    }

    public String toString() {
        return this.keys.toString();
    }
}

