/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search.extractor;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;

public class ImplicitTiebreakerHitExtractor
implements HitExtractor {
    public static final HitExtractor INSTANCE = new ImplicitTiebreakerHitExtractor();
    static final String NAME = "tb";

    private ImplicitTiebreakerHitExtractor() {
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    public String getWriteableName() {
        return NAME;
    }

    public Object extract(SearchHit hit) {
        Object[] sortValues = hit.getRawSortValues();
        if (sortValues.length == 0) {
            throw new EqlIllegalArgumentException("Expected at least one sorting value in the search hit, but got none");
        }
        return sortValues[sortValues.length - 1];
    }

    public String hitName() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return ImplicitTiebreakerHitExtractor.class.hashCode();
    }

    public String toString() {
        return "_shard_doc";
    }
}

