/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class ConcatFunctionProcessor
implements Processor {
    public static final String NAME = "scon";
    private final List<Processor> values;

    public ConcatFunctionProcessor(List<Processor> values) {
        this.values = values;
    }

    public final void writeTo(StreamOutput out) throws IOException {
        for (Processor v : this.values) {
            out.writeNamedWriteable((NamedWriteable)v);
        }
    }

    public Object process(Object input) {
        ArrayList<Object> processed = new ArrayList<Object>(this.values.size());
        for (Processor v : this.values) {
            processed.add(v.process(input));
        }
        return ConcatFunctionProcessor.doProcess(processed);
    }

    public static Object doProcess(List<Object> inputs) {
        if (inputs == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (Object input : inputs) {
            if (input == null) {
                return null;
            }
            str.append(input.toString());
        }
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.values, ((ConcatFunctionProcessor)obj).values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String getWriteableName() {
        return NAME;
    }
}

