/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class EndsWithFunctionProcessor
implements Processor {
    public static final String NAME = "senw";
    private final Processor input;
    private final Processor pattern;
    private final boolean caseInsensitive;

    public EndsWithFunctionProcessor(Processor input, Processor pattern, boolean caseInsensitive) {
        this.input = input;
        this.pattern = pattern;
        this.caseInsensitive = caseInsensitive;
    }

    public EndsWithFunctionProcessor(StreamInput in) throws IOException {
        this.input = (Processor)in.readNamedWriteable(Processor.class);
        this.pattern = (Processor)in.readNamedWriteable(Processor.class);
        this.caseInsensitive = in.readBoolean();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.input);
        out.writeNamedWriteable((NamedWriteable)this.pattern);
        out.writeBoolean(this.caseInsensitive);
    }

    public Object process(Object o) {
        return EndsWithFunctionProcessor.doProcess(this.input.process(o), this.pattern.process(o), this.isCaseInsensitive());
    }

    public static Object doProcess(Object input, Object pattern, boolean isCaseInsensitive) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof String) && !(input instanceof Character)) {
            throw new EqlIllegalArgumentException("A string/char is required; received [{}]", input);
        }
        if (pattern == null) {
            return null;
        }
        if (!(pattern instanceof String) && !(pattern instanceof Character)) {
            throw new EqlIllegalArgumentException("A string/char is required; received [{}]", pattern);
        }
        if (!isCaseInsensitive) {
            return input.toString().endsWith(pattern.toString());
        }
        return input.toString().toLowerCase(Locale.ROOT).endsWith(pattern.toString().toLowerCase(Locale.ROOT));
    }

    protected Processor input() {
        return this.input;
    }

    protected Processor pattern() {
        return this.pattern;
    }

    protected boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EndsWithFunctionProcessor other = (EndsWithFunctionProcessor)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.isCaseInsensitive(), other.isCaseInsensitive());
    }

    public int hashCode() {
        return Objects.hash(this.input(), this.pattern(), this.isCaseInsensitive());
    }

    public String getWriteableName() {
        return NAME;
    }
}

