/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class KeyedFilter
extends UnaryPlan {
    private final List<? extends NamedExpression> keys;
    private final Attribute timestamp;
    private final Attribute tiebreaker;
    private final boolean isMissingEventFilter;

    public KeyedFilter(Source source, LogicalPlan child, List<? extends NamedExpression> keys, Attribute timestamp, Attribute tiebreaker, boolean isMissingEventFilter) {
        super(source, child);
        this.keys = keys;
        this.timestamp = timestamp;
        this.tiebreaker = tiebreaker;
        this.isMissingEventFilter = isMissingEventFilter;
    }

    protected NodeInfo<KeyedFilter> info() {
        return NodeInfo.create((Node)this, KeyedFilter::new, (Object)this.child(), this.keys, (Object)this.timestamp, (Object)this.tiebreaker, (Object)this.isMissingEventFilter);
    }

    public KeyedFilter replaceChild(LogicalPlan newChild) {
        return new KeyedFilter(this.source(), newChild, this.keys, this.timestamp, this.tiebreaker, this.isMissingEventFilter);
    }

    public List<? extends NamedExpression> keys() {
        return this.keys;
    }

    public Attribute timestamp() {
        return this.timestamp;
    }

    public Attribute tiebreaker() {
        return this.tiebreaker;
    }

    public List<? extends NamedExpression> extractionAttributes() {
        ArrayList<Object> out = new ArrayList<Object>();
        if (Expressions.isPresent((NamedExpression)this.timestamp)) {
            out.add(this.timestamp);
        }
        if (Expressions.isPresent((NamedExpression)this.tiebreaker)) {
            out.add(this.tiebreaker);
        }
        out.addAll(this.keys);
        return out;
    }

    public boolean expressionsResolved() {
        return Resolvables.resolved(this.keys) && this.timestamp.resolved() && this.tiebreaker.resolved();
    }

    public boolean isMissingEventFilter() {
        return this.isMissingEventFilter;
    }

    public int hashCode() {
        return Objects.hash(this.keys, this.timestamp, this.tiebreaker, this.child(), this.isMissingEventFilter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        KeyedFilter other = (KeyedFilter)((Object)obj);
        return Objects.equals(this.keys, other.keys) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.tiebreaker, other.tiebreaker) && Objects.equals(this.child(), other.child()) && this.isMissingEventFilter == this.isMissingEventFilter;
    }
}

