/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.azure.storage.blob.implementation.models.ServicesFilterBlobsHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobContainerListDetails;
import com.azure.storage.blob.models.BlobCorsRule;
import com.azure.storage.blob.models.BlobRetentionPolicy;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.blob.models.BlobServiceStatistics;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.KeyInfo;
import com.azure.storage.blob.models.ListBlobContainersIncludeType;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.TaggedBlobItem;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.azure.storage.blob.options.FindBlobsOptions;
import com.azure.storage.blob.options.UndeleteBlobContainerOptions;
import com.azure.storage.common.implementation.AccountSasImplUtil;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import java.net.URI;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=BlobServiceClientBuilder.class, isAsync=true)
public final class BlobServiceAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(BlobServiceAsyncClient.class);
    private final AzureBlobStorageImpl azureBlobStorage;
    private final String accountName;
    private final BlobServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    private final EncryptionScope encryptionScope;
    private final BlobContainerEncryptionScope blobContainerEncryptionScope;
    private final boolean anonymousAccess;

    BlobServiceAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, BlobContainerEncryptionScope blobContainerEncryptionScope, boolean anonymousAccess) {
        try {
            URI.create(url);
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)ex);
        }
        this.azureBlobStorage = new AzureBlobStorageImplBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
        this.anonymousAccess = anonymousAccess;
    }

    public BlobContainerAsyncClient getBlobContainerAsyncClient(String containerName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)containerName)) {
            containerName = "$root";
        }
        return new BlobContainerAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), containerName, this.customerProvidedKey, this.encryptionScope, this.blobContainerEncryptionScope);
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobContainerAsyncClient> createBlobContainer(String containerName) {
        return this.createBlobContainerWithResponse(containerName, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobContainerAsyncClient>> createBlobContainerWithResponse(String containerName, Map<String, String> metadata, PublicAccessType accessType) {
        try {
            return FluxUtil.withContext(context -> this.createBlobContainerWithResponse(containerName, metadata, accessType, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobContainerAsyncClient>> createBlobContainerWithResponse(String containerName, Map<String, String> metadata, PublicAccessType accessType, Context context) {
        this.throwOnAnonymousAccess();
        BlobContainerAsyncClient blobContainerAsyncClient = this.getBlobContainerAsyncClient(containerName);
        return blobContainerAsyncClient.createWithResponse(metadata, accessType, context).map(response -> new SimpleResponse(response, (Object)blobContainerAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobContainerAsyncClient> createBlobContainerIfNotExists(String containerName) {
        return this.createBlobContainerIfNotExistsWithResponse(containerName, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobContainerAsyncClient>> createBlobContainerIfNotExistsWithResponse(String containerName, BlobContainerCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createBlobContainerIfNotExistsWithResponse(containerName, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobContainerAsyncClient>> createBlobContainerIfNotExistsWithResponse(String containerName, BlobContainerCreateOptions options, Context context) {
        try {
            options = options == null ? new BlobContainerCreateOptions() : options;
            return this.createBlobContainerWithResponse(containerName, options.getMetadata(), options.getPublicAccessType(), context).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)((Object)((Object)t))).getStatusCode() == 409, t -> {
                HttpResponse response = ((BlobStorageException)((Object)((Object)t))).getResponse();
                return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)this.getBlobContainerAsyncClient(containerName)));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBlobContainer(String containerName) {
        return this.deleteBlobContainerWithResponse(containerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBlobContainerWithResponse(String containerName) {
        try {
            return FluxUtil.withContext(context -> this.deleteBlobContainerWithResponse(containerName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteBlobContainerWithResponse(String containerName, Context context) {
        this.throwOnAnonymousAccess();
        return this.getBlobContainerAsyncClient(containerName).deleteWithResponse(null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteBlobContainerIfExists(String containerName) {
        return this.deleteBlobContainerIfExistsWithResponse(containerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteBlobContainerIfExistsWithResponse(String containerName) {
        try {
            return FluxUtil.withContext(context -> this.deleteBlobContainerIfExistsWithResponse(containerName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> deleteBlobContainerIfExistsWithResponse(String containerName, Context context) {
        try {
            return this.deleteBlobContainerWithResponse(containerName, context).map(response -> new SimpleResponse(response, (Object)true)).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)((Object)((Object)t))).getStatusCode() == 404, t -> {
                HttpResponse response = ((BlobStorageException)((Object)((Object)t))).getResponse();
                return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public String getAccountUrl() {
        return this.azureBlobStorage.getUrl();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainers() {
        return this.listBlobContainers(new ListBlobContainersOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainers(ListBlobContainersOptions options) {
        try {
            return this.listBlobContainersWithOptionalTimeout(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<BlobContainerItem> listBlobContainersWithOptionalTimeout(ListBlobContainersOptions options, Duration timeout) {
        this.throwOnAnonymousAccess();
        BiFunction<String, Integer, Mono> func = (marker, pageSize) -> {
            ListBlobContainersOptions finalOptions = pageSize != null ? (options == null ? new ListBlobContainersOptions().setMaxResultsPerPage((Integer)pageSize) : new ListBlobContainersOptions().setMaxResultsPerPage((Integer)pageSize).setDetails(options.getDetails()).setPrefix(options.getPrefix())) : options;
            return this.listBlobContainersSegment((String)marker, finalOptions, timeout);
        };
        return new PagedFlux(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegment(String marker, ListBlobContainersOptions options, Duration timeout) {
        options = options == null ? new ListBlobContainersOptions() : options;
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getServices().listBlobContainersSegmentSinglePageAsync(options.getPrefix(), marker, options.getMaxResultsPerPage(), this.toIncludeTypes(options.getDetails()), null, null, Context.NONE), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TaggedBlobItem> findBlobsByTags(String query) {
        return this.findBlobsByTags(new FindBlobsOptions(query));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options) {
        try {
            return this.findBlobsByTags(options, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options, Duration timeout, Context context) {
        this.throwOnAnonymousAccess();
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BiFunction<String, Integer, Mono> func = (marker, pageSize) -> {
            FindBlobsOptions finalOptions = pageSize != null ? new FindBlobsOptions(options.getQuery()).setMaxResultsPerPage((Integer)pageSize) : options;
            return this.findBlobsByTags(finalOptions, (String)marker, timeout, context);
        };
        return new PagedFlux(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<PagedResponse<TaggedBlobItem>> findBlobsByTags(FindBlobsOptions options, String marker, Duration timeout, Context context) {
        this.throwOnAnonymousAccess();
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getServices().filterBlobsWithResponseAsync(null, null, options.getQuery(), marker, options.getMaxResultsPerPage(), null, context), (Duration)timeout).map(response -> {
            List value = ((FilterBlobSegment)response.getValue()).getBlobs() == null ? Collections.emptyList() : ((FilterBlobSegment)response.getValue()).getBlobs().stream().map(ModelHelper::populateTaggedBlobItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FilterBlobSegment)response.getValue()).getNextMarker(), (Object)((ServicesFilterBlobsHeaders)response.getDeserializedHeaders()));
        });
    }

    private List<ListBlobContainersIncludeType> toIncludeTypes(BlobContainerListDetails blobContainerListDetails) {
        boolean hasDetails;
        boolean bl = hasDetails = blobContainerListDetails != null && (blobContainerListDetails.getRetrieveMetadata() || blobContainerListDetails.getRetrieveDeleted() || blobContainerListDetails.getRetrieveSystemContainers());
        if (hasDetails) {
            ArrayList<ListBlobContainersIncludeType> flags = new ArrayList<ListBlobContainersIncludeType>(3);
            if (blobContainerListDetails.getRetrieveDeleted()) {
                flags.add(ListBlobContainersIncludeType.DELETED);
            }
            if (blobContainerListDetails.getRetrieveMetadata()) {
                flags.add(ListBlobContainersIncludeType.METADATA);
            }
            if (blobContainerListDetails.getRetrieveSystemContainers()) {
                flags.add(ListBlobContainersIncludeType.SYSTEM);
            }
            return flags;
        }
        return null;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobServiceProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        this.throwOnAnonymousAccess();
        return this.azureBlobStorage.getServices().getPropertiesWithResponseAsync(null, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobServiceProperties)rb.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setProperties(BlobServiceProperties properties) {
        return this.setPropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesWithResponse(BlobServiceProperties properties) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(properties, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setPropertiesWithResponse(BlobServiceProperties properties, Context context) {
        this.throwOnAnonymousAccess();
        BlobServiceProperties finalProperties = null;
        if (properties != null) {
            finalProperties = new BlobServiceProperties();
            finalProperties.setLogging(properties.getLogging());
            if (finalProperties.getLogging() != null) {
                StorageImplUtils.assertNotNull((String)"Logging Version", (Object)finalProperties.getLogging().getVersion());
                this.validateRetentionPolicy(finalProperties.getLogging().getRetentionPolicy(), "Logging Retention Policy");
            }
            finalProperties.setHourMetrics(properties.getHourMetrics());
            if (finalProperties.getHourMetrics() != null) {
                StorageImplUtils.assertNotNull((String)"HourMetrics Version", (Object)finalProperties.getHourMetrics().getVersion());
                this.validateRetentionPolicy(finalProperties.getHourMetrics().getRetentionPolicy(), "HourMetrics Retention Policy");
                if (finalProperties.getHourMetrics().isEnabled()) {
                    StorageImplUtils.assertNotNull((String)"HourMetrics IncludeApis", (Object)finalProperties.getHourMetrics().isIncludeApis());
                }
            }
            finalProperties.setMinuteMetrics(properties.getMinuteMetrics());
            if (finalProperties.getMinuteMetrics() != null) {
                StorageImplUtils.assertNotNull((String)"MinuteMetrics Version", (Object)finalProperties.getMinuteMetrics().getVersion());
                this.validateRetentionPolicy(finalProperties.getMinuteMetrics().getRetentionPolicy(), "MinuteMetrics Retention Policy");
                if (finalProperties.getMinuteMetrics().isEnabled()) {
                    StorageImplUtils.assertNotNull((String)"MinuteMetrics IncludeApis", (Object)finalProperties.getHourMetrics().isIncludeApis());
                }
            }
            if (properties.getCors() != null) {
                ArrayList<BlobCorsRule> corsRules = new ArrayList<BlobCorsRule>();
                for (BlobCorsRule rule : properties.getCors()) {
                    corsRules.add(this.validatedCorsRule(rule));
                }
                finalProperties.setCors(corsRules);
            }
            finalProperties.setDefaultServiceVersion(properties.getDefaultServiceVersion());
            finalProperties.setDeleteRetentionPolicy(properties.getDeleteRetentionPolicy());
            this.validateRetentionPolicy(finalProperties.getDeleteRetentionPolicy(), "DeleteRetentionPolicy Days");
            finalProperties.setStaticWebsite(properties.getStaticWebsite());
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getServices().setPropertiesNoCustomHeadersWithResponseAsync(finalProperties, null, null, context);
    }

    private BlobCorsRule validatedCorsRule(BlobCorsRule originalRule) {
        if (originalRule == null) {
            return null;
        }
        BlobCorsRule validRule = new BlobCorsRule();
        validRule.setAllowedHeaders(StorageImplUtils.emptyIfNull((String)originalRule.getAllowedHeaders()));
        validRule.setAllowedMethods(StorageImplUtils.emptyIfNull((String)originalRule.getAllowedMethods()));
        validRule.setAllowedOrigins(StorageImplUtils.emptyIfNull((String)originalRule.getAllowedOrigins()));
        validRule.setExposedHeaders(StorageImplUtils.emptyIfNull((String)originalRule.getExposedHeaders()));
        validRule.setMaxAgeInSeconds(originalRule.getMaxAgeInSeconds());
        return validRule;
    }

    private void validateRetentionPolicy(BlobRetentionPolicy retentionPolicy, String policyName) {
        if (retentionPolicy == null) {
            return;
        }
        if (retentionPolicy.isEnabled()) {
            StorageImplUtils.assertInBounds((String)policyName, (long)retentionPolicy.getDays().intValue(), (long)1L, (long)365L);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserDelegationKey> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return this.getUserDelegationKeyWithResponse(start, expiry).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UserDelegationKey>> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry) {
        try {
            return FluxUtil.withContext(context -> this.getUserDelegationKeyWithResponse(start, expiry, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<UserDelegationKey>> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry, Context context) {
        StorageImplUtils.assertNotNull((String)"expiry", (Object)expiry);
        if (start != null && !start.isBefore(expiry)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("`start` must be null or a datetime before `expiry`."));
        }
        this.throwOnAnonymousAccess();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getServices().getUserDelegationKeyWithResponseAsync(new KeyInfo().setStart(start == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(start)).setExpiry(Constants.ISO_8601_UTC_DATE_FORMATTER.format(expiry)), null, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((UserDelegationKey)rb.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceStatistics> getStatistics() {
        return this.getStatisticsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceStatistics>> getStatisticsWithResponse() {
        try {
            return FluxUtil.withContext(this::getStatisticsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobServiceStatistics>> getStatisticsWithResponse(Context context) {
        this.throwOnAnonymousAccess();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getServices().getStatisticsWithResponseAsync(null, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobServiceStatistics)rb.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountInfo> getAccountInfo() {
        return this.getAccountInfoWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountInfoWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse(Context context) {
        this.throwOnAnonymousAccess();
        return this.azureBlobStorage.getServices().getAccountInfoWithResponseAsync(null, null, context).map(rb -> {
            ServicesGetAccountInfoHeaders hd = (ServicesGetAccountInfoHeaders)rb.getDeserializedHeaders();
            return new SimpleResponse((Response)rb, (Object)new StorageAccountInfo(hd.getXMsSkuName(), hd.getXMsAccountKind(), hd.isXMsIsHnsEnabled()));
        });
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, Context.NONE);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        this.throwOnAnonymousAccess();
        return new AccountSasImplUtil(accountSasSignatureValues, this.encryptionScope == null ? null : this.encryptionScope.getEncryptionScope()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }

    private void throwOnAnonymousAccess() {
        if (this.anonymousAccess) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Service client cannot be accessed without credentials"));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobContainerAsyncClient> undeleteBlobContainer(String deletedContainerName, String deletedContainerVersion) {
        try {
            return this.undeleteBlobContainerWithResponse(new UndeleteBlobContainerOptions(deletedContainerName, deletedContainerVersion)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobContainerAsyncClient>> undeleteBlobContainerWithResponse(UndeleteBlobContainerOptions options) {
        try {
            return FluxUtil.withContext(context -> this.undeleteBlobContainerWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobContainerAsyncClient>> undeleteBlobContainerWithResponse(UndeleteBlobContainerOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        boolean hasOptionalDestinationContainerName = options.getDestinationContainerName() != null;
        String finalDestinationContainerName = hasOptionalDestinationContainerName ? options.getDestinationContainerName() : options.getDeletedContainerName();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getContainers().restoreWithResponseAsync(finalDestinationContainerName, null, null, options.getDeletedContainerName(), options.getDeletedContainerVersion(), context).map(response -> new SimpleResponse((Response)response, (Object)this.getBlobContainerAsyncClient(finalDestinationContainerName)));
    }
}

