/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

abstract class AbstractHistoBackedTDigestPercentilesAggregator
extends NumericMetricsAggregator.MultiValue {
    protected final double[] keys;
    protected final ValuesSource valuesSource;
    protected final DocValueFormat formatter;
    protected ObjectArray<TDigestState> states;
    protected final double compression;
    protected final TDigestExecutionHint executionHint;
    protected final boolean keyed;

    AbstractHistoBackedTDigestPercentilesAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] keys, double compression, TDigestExecutionHint executionHint, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = config.getValuesSource();
        this.keyed = keyed;
        this.formatter = formatter;
        this.states = context.bigArrays().newObjectArray(1L);
        this.keys = keys;
        this.compression = compression;
        this.executionHint = executionHint;
    }

    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final HistogramValues values = ((HistogramValuesSource.Histogram)this.valuesSource).getHistogramValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                TDigestState state = AbstractHistoBackedTDigestPercentilesAggregator.this.getExistingOrNewHistogram(AbstractHistoBackedTDigestPercentilesAggregator.this.bigArrays(), bucket);
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    while (sketch.next()) {
                        state.add(sketch.value(), sketch.count());
                    }
                }
            }
        };
    }

    private TDigestState getExistingOrNewHistogram(BigArrays bigArrays, long bucket) {
        this.states = bigArrays.grow(this.states, bucket + 1L);
        TDigestState state = (TDigestState)this.states.get(bucket);
        if (state == null) {
            state = TDigestState.createWithoutCircuitBreaking((double)this.compression, (TDigestExecutionHint)this.executionHint);
            this.states.set(bucket, (Object)state);
        }
        return state;
    }

    public boolean hasMetric(String name) {
        return PercentilesConfig.indexOfKey((double[])this.keys, (double)Double.parseDouble(name)) >= 0;
    }

    protected TDigestState getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        return (TDigestState)this.states.get(bucketOrd);
    }

    protected void doClose() {
        Releasables.close(this.states);
    }
}

