/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.slack.message;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.watcher.notification.slack.message.Attachment;
import org.elasticsearch.xpack.watcher.notification.slack.message.Field;
import org.elasticsearch.xpack.watcher.notification.slack.message.SlackMessage;

public class SlackMessageDefaults {
    private static final String FROM_SETTING = SlackMessage.XField.FROM.getPreferredName();
    private static final String TO_SETTING = SlackMessage.XField.TO.getPreferredName();
    private static final String ICON_SETTING = SlackMessage.XField.ICON.getPreferredName();
    private static final String TEXT_SETTING = SlackMessage.XField.TEXT.getPreferredName();
    private static final String ATTACHMENT_SETTING = "attachment";
    public final String from;
    public final String[] to;
    public final String icon;
    public final String text;
    public final AttachmentDefaults attachment;

    public SlackMessageDefaults(Settings settings) {
        this.from = settings.get(FROM_SETTING, null);
        List to = settings.getAsList(TO_SETTING, null);
        this.to = to == null ? null : to.toArray(Strings.EMPTY_ARRAY);
        this.icon = settings.get(ICON_SETTING, null);
        this.text = settings.get(TEXT_SETTING, null);
        this.attachment = new AttachmentDefaults(settings.getAsSettings(ATTACHMENT_SETTING));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackMessageDefaults defaults = (SlackMessageDefaults)o;
        return Objects.equals(this.from, defaults.from) && Arrays.equals(this.to, defaults.to) && Objects.equals(this.icon, defaults.icon) && Objects.equals(this.text, defaults.text) && Objects.equals(this.attachment, defaults.attachment);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.to), this.icon, this.text, this.attachment);
    }

    static class AttachmentDefaults {
        static final String FALLBACK_SETTING = Attachment.XField.FALLBACK.getPreferredName();
        static final String COLOR_SETTING = Attachment.XField.COLOR.getPreferredName();
        static final String PRETEXT_SETTING = Attachment.XField.PRETEXT.getPreferredName();
        static final String AUTHOR_NAME_SETTING = Attachment.XField.AUTHOR_NAME.getPreferredName();
        static final String AUTHOR_LINK_SETTING = Attachment.XField.AUTHOR_LINK.getPreferredName();
        static final String AUTHOR_ICON_SETTING = Attachment.XField.AUTHOR_ICON.getPreferredName();
        static final String TITLE_SETTING = Attachment.XField.TITLE.getPreferredName();
        static final String TITLE_LINK_SETTING = Attachment.XField.TITLE_LINK.getPreferredName();
        static final String TEXT_SETTING = Attachment.XField.TEXT.getPreferredName();
        static final String IMAGE_URL_SETTING = Attachment.XField.IMAGE_URL.getPreferredName();
        static final String THUMB_URL_SETTING = Attachment.XField.THUMB_URL.getPreferredName();
        static final String MARKDOWN_IN_SETTING = Attachment.XField.MARKDOWN_IN.getPreferredName();
        static final String FIELD_SETTING = "field";
        final String fallback;
        final String color;
        final String pretext;
        final String authorName;
        final String authorLink;
        final String authorIcon;
        final String title;
        final String titleLink;
        final String text;
        final String imageUrl;
        final String thumbUrl;
        final List<String> markdownSupportedFields;
        final FieldDefaults field;

        AttachmentDefaults(Settings settings) {
            this.fallback = settings.get(FALLBACK_SETTING, null);
            this.color = settings.get(COLOR_SETTING, null);
            this.pretext = settings.get(PRETEXT_SETTING, null);
            this.authorName = settings.get(AUTHOR_NAME_SETTING, null);
            this.authorLink = settings.get(AUTHOR_LINK_SETTING, null);
            this.authorIcon = settings.get(AUTHOR_ICON_SETTING, null);
            this.title = settings.get(TITLE_SETTING, null);
            this.titleLink = settings.get(TITLE_LINK_SETTING, null);
            this.text = settings.get(TEXT_SETTING, null);
            this.imageUrl = settings.get(IMAGE_URL_SETTING, null);
            this.thumbUrl = settings.get(THUMB_URL_SETTING, null);
            this.markdownSupportedFields = settings.getAsList(MARKDOWN_IN_SETTING, null);
            this.field = new FieldDefaults(settings.getAsSettings(FIELD_SETTING));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttachmentDefaults that = (AttachmentDefaults)o;
            return Objects.equals(this.fallback, that.fallback) && Objects.equals(this.color, that.color) && Objects.equals(this.pretext, that.pretext) && Objects.equals(this.authorName, that.authorName) && Objects.equals(this.authorLink, that.authorLink) && Objects.equals(this.authorIcon, that.authorIcon) && Objects.equals(this.title, that.title) && Objects.equals(this.titleLink, that.titleLink) && Objects.equals(this.text, that.text) && Objects.equals(this.imageUrl, that.imageUrl) && Objects.equals(this.thumbUrl, that.thumbUrl) && Objects.equals(this.field, that.field) && Objects.equals(this.markdownSupportedFields, that.markdownSupportedFields);
        }

        public int hashCode() {
            return Objects.hash(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.thumbUrl, this.field, this.markdownSupportedFields);
        }

        static class FieldDefaults {
            static final String TITLE_SETTING = Field.XField.TITLE.getPreferredName();
            static final String VALUE_SETTING = Field.XField.VALUE.getPreferredName();
            static final String SHORT_SETTING = Field.XField.SHORT.getPreferredName();
            final String title;
            final String value;
            final Boolean isShort;

            FieldDefaults(Settings settings) {
                this.title = settings.get(TITLE_SETTING, null);
                this.value = settings.get(VALUE_SETTING, null);
                this.isShort = settings.getAsBoolean(SHORT_SETTING, null);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                FieldDefaults that = (FieldDefaults)o;
                return Objects.equals(this.title, that.title) && Objects.equals(this.value, that.value) && Objects.equals(this.isShort, that.isShort);
            }

            public int hashCode() {
                return Objects.hash(this.title, this.value, this.isShort);
            }
        }
    }
}

