/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggRowSet;
import org.elasticsearch.xpack.sql.execution.search.Querier;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;
import org.elasticsearch.xpack.sql.util.Check;

public class CompositeAggCursor
implements Cursor {
    private static final Logger log = LogManager.getLogger(CompositeAggCursor.class);
    public static final String NAME = "c";
    private final String[] indices;
    private final SearchSourceBuilder nextQuery;
    private final List<BucketExtractor> extractors;
    private final BitSet mask;
    private final int limit;
    private final boolean includeFrozen;

    CompositeAggCursor(SearchSourceBuilder nextQuery, List<BucketExtractor> exts, BitSet mask, int remainingLimit, boolean includeFrozen, String ... indices) {
        this.indices = indices;
        this.nextQuery = nextQuery;
        this.extractors = exts;
        this.mask = mask;
        this.limit = remainingLimit;
        this.includeFrozen = includeFrozen;
    }

    public CompositeAggCursor(StreamInput in) throws IOException {
        this.indices = in.readStringArray();
        this.nextQuery = new SearchSourceBuilder(in);
        this.limit = in.readVInt();
        this.extractors = in.readNamedWriteableCollectionAsList(BucketExtractor.class);
        this.mask = BitSet.valueOf(in.readByteArray());
        this.includeFrozen = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        this.nextQuery.writeTo(out);
        out.writeVInt(this.limit);
        out.writeNamedWriteableCollection(this.extractors);
        out.writeByteArray(this.mask.toByteArray());
        out.writeBoolean(this.includeFrozen);
    }

    public String getWriteableName() {
        return NAME;
    }

    String[] indices() {
        return this.indices;
    }

    SearchSourceBuilder next() {
        return this.nextQuery;
    }

    BitSet mask() {
        return this.mask;
    }

    List<BucketExtractor> extractors() {
        return this.extractors;
    }

    int limit() {
        return this.limit;
    }

    boolean includeFrozen() {
        return this.includeFrozen;
    }

    protected SearchSourceBuilder nextQuery() {
        return this.nextQuery;
    }

    @Override
    public void nextPage(SqlConfiguration cfg, final Client client, ActionListener<Cursor.Page> listener) {
        if (log.isTraceEnabled()) {
            log.trace("About to execute composite query {} on {}", (Object)StringUtils.toString((SearchSourceBuilder)this.nextQuery), (Object)this.indices);
        }
        final SearchRequest request = Querier.prepareRequest(this.nextQuery, cfg, this.includeFrozen, this.indices);
        client.search(request, (ActionListener)new DelegatingActionListener<SearchResponse, Cursor.Page>(listener){

            public void onResponse(SearchResponse response) {
                CompositeAggCursor.handle(client, response, request.source(), CompositeAggCursor.this.makeRowSet(response), CompositeAggCursor.this.makeCursor(), () -> client.search(request, (ActionListener)this), (ActionListener<Cursor.Page>)this.delegate, CompositeAggCursor.couldProducePartialPages(CompositeAggCursor.getCompositeBuilder(CompositeAggCursor.this.next())));
            }
        });
    }

    protected Supplier<CompositeAggRowSet> makeRowSet(SearchResponse response) {
        CompositeAggregationBuilder aggregation = CompositeAggCursor.getCompositeBuilder(this.nextQuery);
        return () -> new CompositeAggRowSet(this.extractors, this.mask, response, aggregation.size(), this.limit, CompositeAggCursor.couldProducePartialPages(aggregation));
    }

    protected BiFunction<SearchSourceBuilder, CompositeAggRowSet, CompositeAggCursor> makeCursor() {
        return (q, r) -> new CompositeAggCursor((SearchSourceBuilder)q, r.extractors(), r.mask(), r.remainingData(), this.includeFrozen, this.indices);
    }

    static void handle(Client client, SearchResponse response, SearchSourceBuilder source, Supplier<CompositeAggRowSet> makeRowSet, BiFunction<SearchSourceBuilder, CompositeAggRowSet, CompositeAggCursor> makeCursor, Runnable retry, ActionListener<Cursor.Page> listener, boolean couldProducePartialPages) {
        if (log.isTraceEnabled()) {
            Querier.logSearchResponse(response, log);
        }
        if (couldProducePartialPages && CompositeAggCursor.shouldRetryDueToEmptyPage(response)) {
            CompositeAggCursor.updateCompositeAfterKey(response, source);
            retry.run();
            return;
        }
        CompositeAggRowSet rowSet = makeRowSet.get();
        Map<String, Object> afterKey = rowSet.afterKey();
        if (afterKey != null) {
            CompositeAggCursor.updateSourceAfterKey(afterKey, source);
        }
        if (rowSet.remainingData() == 0) {
            Querier.closePointInTime(client, response.pointInTimeId(), (ActionListener<Boolean>)listener.map(r -> Cursor.Page.last(rowSet)));
        } else {
            listener.onResponse((Object)new Cursor.Page(rowSet, makeCursor.apply(source, rowSet)));
        }
    }

    private static boolean shouldRetryDueToEmptyPage(SearchResponse response) {
        CompositeAggregation composite = CompositeAggCursor.getComposite(response);
        return composite.getBuckets().isEmpty() && composite.afterKey() != null && !composite.afterKey().isEmpty();
    }

    static CompositeAggregationBuilder getCompositeBuilder(SearchSourceBuilder source) {
        AggregationBuilder aggregation = source.aggregations().getAggregatorFactories().stream().filter(a -> Objects.equals(a.getName(), "groupby")).findFirst().orElse(null);
        Check.isTrue(aggregation instanceof CompositeAggregationBuilder, "Unexpected aggregation builder " + String.valueOf(aggregation));
        return (CompositeAggregationBuilder)aggregation;
    }

    static boolean couldProducePartialPages(CompositeAggregationBuilder aggregation) {
        for (PipelineAggregationBuilder agg : aggregation.getPipelineAggregations()) {
            if (!agg.getType().equals("bucket_selector")) continue;
            return true;
        }
        return false;
    }

    static CompositeAggregation getComposite(SearchResponse response) {
        InternalAggregation agg = response.getAggregations().get("groupby");
        Check.isTrue(agg instanceof CompositeAggregation, "Unrecognized root group found; " + String.valueOf(agg));
        return (CompositeAggregation)agg;
    }

    private static void updateCompositeAfterKey(SearchResponse r, SearchSourceBuilder search) {
        CompositeAggCursor.updateSourceAfterKey(CompositeAggCursor.getComposite(r).afterKey(), search);
    }

    private static void updateSourceAfterKey(Map<String, Object> afterKey, SearchSourceBuilder search) {
        AggregationBuilder aggBuilder = (AggregationBuilder)search.aggregations().getAggregatorFactories().iterator().next();
        if (!(aggBuilder instanceof CompositeAggregationBuilder)) {
            throw new SqlIllegalArgumentException("Invalid client request; expected a group-by but instead got {}", aggBuilder);
        }
        CompositeAggregationBuilder comp = (CompositeAggregationBuilder)aggBuilder;
        comp.aggregateAfter(afterKey);
    }

    @Override
    public void clear(Client client, ActionListener<Boolean> listener) {
        Check.isTrue(this.nextQuery().pointInTimeBuilder() != null, "Expected cursor with point-in-time id but got null");
        Querier.closePointInTime(client, this.nextQuery().pointInTimeBuilder().getEncodedId(), listener);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.nextQuery, this.extractors, this.limit, this.mask, this.includeFrozen);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompositeAggCursor other = (CompositeAggCursor)obj;
        return Arrays.equals(this.indices, other.indices) && Objects.equals(this.nextQuery, other.nextQuery) && Objects.equals(this.extractors, other.extractors) && Objects.equals(this.limit, other.limit) && Objects.equals(this.includeFrozen, other.includeFrozen);
    }

    public String toString() {
        return "cursor for composite on index [" + Arrays.toString(this.indices) + "]";
    }
}

