/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class SubQueryExpression
extends Expression {
    private final LogicalPlan query;
    private final NameId id;

    public SubQueryExpression(Source source, LogicalPlan query) {
        this(source, query, null);
    }

    public SubQueryExpression(Source source, LogicalPlan query, NameId id) {
        super(source, Collections.emptyList());
        this.query = query;
        this.id = id == null ? new NameId() : id;
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    public LogicalPlan query() {
        return this.query;
    }

    public NameId id() {
        return this.id;
    }

    public boolean resolved() {
        return false;
    }

    public SubQueryExpression withQuery(LogicalPlan newQuery) {
        return Objects.equals(this.query, newQuery) ? this : this.clone(newQuery);
    }

    protected abstract SubQueryExpression clone(LogicalPlan var1);

    public int hashCode() {
        return Objects.hash(this.query());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SubQueryExpression other = (SubQueryExpression)((Object)obj);
        return Objects.equals(this.query(), other.query());
    }
}

