/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ReplaceFunctionProcessor;

public class ReplaceFunctionPipe
extends Pipe {
    private final Pipe input;
    private final Pipe pattern;
    private final Pipe replacement;

    public ReplaceFunctionPipe(Source source, Expression expression, Pipe input, Pipe pattern, Pipe replacement) {
        super(source, expression, Arrays.asList(input, pattern, replacement));
        this.input = input;
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public final Pipe replaceChildren(List<Pipe> newChildren) {
        return this.replaceChildren(newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newInput = this.input.resolveAttributes(resolver);
        Pipe newPattern = this.pattern.resolveAttributes(resolver);
        Pipe newReplacement = this.replacement.resolveAttributes(resolver);
        if (newInput == this.input && newPattern == this.pattern && newReplacement == this.replacement) {
            return this;
        }
        return this.replaceChildren(newInput, newPattern, newReplacement);
    }

    public boolean supportedByAggsOnlyQuery() {
        return this.input.supportedByAggsOnlyQuery() && this.pattern.supportedByAggsOnlyQuery() && this.replacement.supportedByAggsOnlyQuery();
    }

    public boolean resolved() {
        return this.input.resolved() && this.pattern.resolved() && this.replacement.resolved();
    }

    protected Pipe replaceChildren(Pipe newInput, Pipe newPattern, Pipe newReplacement) {
        return new ReplaceFunctionPipe(this.source(), this.expression(), newInput, newPattern, newReplacement);
    }

    public final void collectFields(QlSourceBuilder sourceBuilder) {
        this.input.collectFields(sourceBuilder);
        this.pattern.collectFields(sourceBuilder);
        this.replacement.collectFields(sourceBuilder);
    }

    protected NodeInfo<ReplaceFunctionPipe> info() {
        return NodeInfo.create((Node)this, ReplaceFunctionPipe::new, (Object)this.expression(), (Object)this.input, (Object)this.pattern, (Object)this.replacement);
    }

    public ReplaceFunctionProcessor asProcessor() {
        return new ReplaceFunctionProcessor(this.input.asProcessor(), this.pattern.asProcessor(), this.replacement.asProcessor());
    }

    public Pipe input() {
        return this.input;
    }

    public Pipe pattern() {
        return this.pattern;
    }

    public Pipe replacement() {
        return this.replacement;
    }

    public int hashCode() {
        return Objects.hash(this.input, this.pattern, this.replacement);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReplaceFunctionPipe other = (ReplaceFunctionPipe)((Object)obj);
        return Objects.equals(this.input, other.input) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.replacement, other.replacement);
    }
}

