/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;

public final class ExpandedIdsMatcher {
    public static String ALL = "_all";
    private final List<IdMatcher> allMatchers;
    private final List<IdMatcher> requiredMatches = new LinkedList<IdMatcher>();
    private final boolean onlyExact;

    public static String[] tokenizeExpression(String expression) {
        return Strings.tokenizeToStringArray((String)expression, (String)",");
    }

    public ExpandedIdsMatcher(String[] tokens, boolean allowNoMatchForWildcards) {
        ArrayList<IdMatcher> allMatchers = new ArrayList<IdMatcher>();
        if (Strings.isAllOrWildcard((String[])tokens)) {
            WildcardMatcher matcher = new WildcardMatcher("*");
            this.allMatchers = Collections.singletonList(matcher);
            if (!allowNoMatchForWildcards) {
                this.requiredMatches.add(matcher);
            }
            this.onlyExact = false;
            return;
        }
        boolean atLeastOneWildcard = false;
        if (allowNoMatchForWildcards) {
            for (String token : tokens) {
                if (Regex.isSimpleMatchPattern((String)token)) {
                    allMatchers.add(new WildcardMatcher(token));
                    atLeastOneWildcard = true;
                    continue;
                }
                EqualsIdMatcher matcher = new EqualsIdMatcher(token);
                allMatchers.add(matcher);
                this.requiredMatches.add(matcher);
            }
        } else {
            for (String token : tokens) {
                IdMatcher matcher;
                if (Regex.isSimpleMatchPattern((String)token)) {
                    matcher = new WildcardMatcher(token);
                    allMatchers.add(matcher);
                    this.requiredMatches.add(matcher);
                    atLeastOneWildcard = true;
                    continue;
                }
                matcher = new EqualsIdMatcher(token);
                allMatchers.add(matcher);
                this.requiredMatches.add(matcher);
            }
        }
        this.onlyExact = !atLeastOneWildcard;
        this.allMatchers = Collections.unmodifiableList(allMatchers);
    }

    public ExpandedIdsMatcher(String expression, boolean allowNoMatchForWildcards) {
        this(ExpandedIdsMatcher.tokenizeExpression(expression), allowNoMatchForWildcards);
    }

    public boolean idMatches(String id) {
        return this.allMatchers.stream().anyMatch(idMatcher -> idMatcher.matches(id));
    }

    public void filterMatchedIds(Collection<String> ids) {
        for (String id : ids) {
            Iterator<IdMatcher> itr = this.requiredMatches.iterator();
            if (!itr.hasNext()) break;
            while (itr.hasNext()) {
                if (!itr.next().matches(id)) continue;
                itr.remove();
            }
        }
    }

    public boolean hasUnmatchedIds() {
        return !this.requiredMatches.isEmpty();
    }

    public List<String> unmatchedIds() {
        return this.requiredMatches.stream().map(IdMatcher::getId).collect(Collectors.toList());
    }

    public String unmatchedIdsString() {
        return this.requiredMatches.stream().map(IdMatcher::getId).collect(Collectors.joining(","));
    }

    public boolean isOnlyExact() {
        return this.onlyExact;
    }

    private static class WildcardMatcher
    extends IdMatcher {
        WildcardMatcher(String id) {
            super(id);
        }

        @Override
        public boolean matches(String id) {
            return Regex.simpleMatch((String)this.id, (String)id);
        }
    }

    private static class EqualsIdMatcher
    extends IdMatcher {
        EqualsIdMatcher(String id) {
            super(id);
        }

        @Override
        public boolean matches(String id) {
            return this.id.equals(id);
        }
    }

    private static abstract class IdMatcher {
        protected final String id;

        IdMatcher(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public abstract boolean matches(String var1);
    }

    public static class SimpleIdsMatcher {
        private final List<IdMatcher> matchers;

        public SimpleIdsMatcher(String[] tokens) {
            if (Strings.isAllOrWildcard((String[])tokens)) {
                this.matchers = Collections.singletonList(new WildcardMatcher("*"));
                return;
            }
            this.matchers = Arrays.stream(tokens).map(token -> Regex.isSimpleMatchPattern((String)token) ? new WildcardMatcher((String)token) : new EqualsIdMatcher((String)token)).collect(Collectors.toList());
        }

        public SimpleIdsMatcher(String expression) {
            this(ExpandedIdsMatcher.tokenizeExpression(expression));
        }

        public boolean idMatches(String id) {
            return this.matchers.stream().anyMatch(idMatcher -> idMatcher.matches(id));
        }
    }
}

