/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DownsampleBeforeBulkInfo(long currentTimeMillis, long executionId, long estimatedSizeInBytes, int numberOfActions) implements NamedWriteable,
ToXContentObject
{
    public static final String NAME = "rollup_before_bulk_info";
    private static final ParseField CURRENT_TIME_IN_MILLIS = new ParseField("current_time_in_millis", new String[0]);
    private static final ParseField EXECUTION_ID = new ParseField("execution_id", new String[0]);
    private static final ParseField ESTIMATED_SIZE_IN_BYTES = new ParseField("estimated_size_in_bytes", new String[0]);
    private static final ParseField NUMBER_OF_ACTIONS = new ParseField("number_of_actions", new String[0]);
    private static final ConstructingObjectParser<DownsampleBeforeBulkInfo, Void> PARSER = new ConstructingObjectParser("rollup_before_bulk_info", args -> new DownsampleBeforeBulkInfo((Long)args[0], (Long)args[1], (Long)args[2], (Integer)args[3]));

    public DownsampleBeforeBulkInfo(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong(), in.readVLong(), in.readVInt());
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.currentTimeMillis);
        out.writeVLong(this.executionId);
        out.writeVLong(this.estimatedSizeInBytes);
        out.writeVInt(this.numberOfActions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(CURRENT_TIME_IN_MILLIS.getPreferredName(), this.currentTimeMillis);
        builder.field(EXECUTION_ID.getPreferredName(), this.executionId);
        builder.field(ESTIMATED_SIZE_IN_BYTES.getPreferredName(), this.estimatedSizeInBytes);
        builder.field(NUMBER_OF_ACTIONS.getPreferredName(), this.numberOfActions);
        return builder.endObject();
    }

    public static DownsampleBeforeBulkInfo fromXContent(XContentParser parser) throws IOException {
        return (DownsampleBeforeBulkInfo)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), CURRENT_TIME_IN_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), EXECUTION_ID);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), ESTIMATED_SIZE_IN_BYTES);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUMBER_OF_ACTIONS);
    }
}

