/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.calendars;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class Calendar
implements ToXContentObject,
Writeable {
    public static final String CALENDAR_TYPE = "calendar";
    public static final ParseField TYPE = new ParseField("type", new String[0]);
    public static final ParseField JOB_IDS = new ParseField("job_ids", new String[0]);
    public static final ParseField ID = new ParseField("calendar_id", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    private static final String DOCUMENT_ID_PREFIX = "calendar_";
    public static final ParseField RESULTS_FIELD = new ParseField("calendars", new String[0]);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = Calendar.createParser(false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = Calendar.createParser(true);
    private final String id;
    private final List<String> jobIds;
    private final String description;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(ID.getPreferredName(), ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setId, ID);
        parser.declareStringArray(Builder::setJobIds, JOB_IDS);
        parser.declareString((builder, s) -> {}, TYPE);
        parser.declareStringOrNull(Builder::setDescription, DESCRIPTION);
        return parser;
    }

    public static String documentId(String calendarId) {
        return DOCUMENT_ID_PREFIX + calendarId;
    }

    public Calendar(String id, List<String> jobIds, @Nullable String description) {
        this.id = Objects.requireNonNull(id, ID.getPreferredName() + " must not be null");
        this.jobIds = Objects.requireNonNull(jobIds, JOB_IDS.getPreferredName() + " must not be null");
        this.description = description;
    }

    public Calendar(StreamInput in) throws IOException {
        this.id = in.readString();
        this.jobIds = Arrays.asList(in.readStringArray());
        this.description = in.readOptionalString();
    }

    public String getId() {
        return this.id;
    }

    public String documentId() {
        return Calendar.documentId(this.id);
    }

    public List<String> getJobIds() {
        return Collections.unmodifiableList(this.jobIds);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeStringCollection(this.jobIds);
        out.writeOptionalString(this.description);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.field(JOB_IDS.getPreferredName(), this.jobIds);
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(TYPE.getPreferredName(), CALENDAR_TYPE);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Calendar)) {
            return false;
        }
        Calendar other = (Calendar)obj;
        return this.id.equals(other.id) && this.jobIds.equals(other.jobIds) && Objects.equals(this.description, other.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobIds, this.description);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String calendarId;
        private List<String> jobIds = Collections.emptyList();
        private String description;

        public String getId() {
            return this.calendarId;
        }

        public void setId(String id) {
            this.calendarId = id;
        }

        public Builder setJobIds(List<String> jobIds) {
            this.jobIds = jobIds;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Calendar build() {
            return new Calendar(this.calendarId, this.jobIds, this.description);
        }
    }
}

