/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class VocabularyConfig
implements ToXContentObject,
Writeable {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ConstructingObjectParser<VocabularyConfig, Void> PARSER = new ConstructingObjectParser("vocabulary_config", true, a -> new VocabularyConfig((String)a[0]));
    private final String index;

    public static String docId(String modelId) {
        return modelId + "_vocabulary";
    }

    public static VocabularyConfig fromXContentLenient(XContentParser parser) {
        return (VocabularyConfig)PARSER.apply(parser, null);
    }

    public VocabularyConfig(String index) {
        this.index = ExceptionsHelper.requireNonNull(index, INDEX);
    }

    public VocabularyConfig(StreamInput in) throws IOException {
        this.index = in.readString();
    }

    public String getIndex() {
        return this.index;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VocabularyConfig that = (VocabularyConfig)o;
        return Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX);
    }
}

