/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import joptsimple.OptionSet;
import org.elasticsearch.Build;
import org.elasticsearch.cli.CliToolProvider;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.cli.PluginSyncException;
import org.elasticsearch.plugins.cli.SyncPluginsAction;

public class SyncPluginsCliProvider
implements CliToolProvider {
    public String name() {
        return "sync-plugins";
    }

    public Command create() {
        return new EnvironmentAwareCommand("sync installed plugins from elasticsearch-plugins.yml"){

            public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
                SyncPluginsAction action = new SyncPluginsAction(terminal, env);
                if (!Files.exists(env.configDir().resolve("elasticsearch-plugins.yml"), new LinkOption[0])) {
                    return;
                }
                if (Build.current().type() != Build.Type.DOCKER) {
                    throw new UserException(78, "Can only use [elasticsearch-plugins.yml] config file with distribution type [docker]");
                }
                try {
                    action.execute();
                }
                catch (PluginSyncException e) {
                    throw new UserException(78, "elasticsearch-plugins.yml: " + e.getMessage());
                }
            }
        };
    }
}

