/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.TreeMap;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleRequest;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleResponse;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleExplainResponse;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.WaitForRolloverReadyStep;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;

public class TransportExplainLifecycleAction
extends TransportClusterInfoAction<ExplainLifecycleRequest, ExplainLifecycleResponse> {
    private final NamedXContentRegistry xContentRegistry;
    private final IndexLifecycleService indexLifecycleService;

    @Inject
    public TransportExplainLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndexLifecycleService indexLifecycleService) {
        super("indices:admin/ilm/explain", transportService, clusterService, threadPool, actionFilters, ExplainLifecycleRequest::new, indexNameExpressionResolver, ExplainLifecycleResponse::new);
        this.xContentRegistry = xContentRegistry;
        this.indexLifecycleService = indexLifecycleService;
    }

    protected void doMasterOperation(Task task, ExplainLifecycleRequest request, String[] concreteIndices, ClusterState state, ActionListener<ExplainLifecycleResponse> listener) {
        boolean rolloverOnlyIfHasDocuments = (Boolean)LifecycleSettings.LIFECYCLE_ROLLOVER_ONLY_IF_HAS_DOCUMENTS_SETTING.get(state.metadata().settings());
        TreeMap<String, IndexLifecycleExplainResponse> indexResponses = new TreeMap<String, IndexLifecycleExplainResponse>();
        for (String index : concreteIndices) {
            IndexLifecycleExplainResponse indexResponse;
            try {
                indexResponse = TransportExplainLifecycleAction.getIndexLifecycleExplainResponse(index, state.metadata(), request.onlyErrors(), request.onlyManaged(), this.indexLifecycleService, this.xContentRegistry, rolloverOnlyIfHasDocuments);
            }
            catch (IOException e) {
                listener.onFailure((Exception)new ElasticsearchParseException("failed to parse phase definition for index [" + index + "]", (Throwable)e, new Object[0]));
                return;
            }
            if (indexResponse == null) continue;
            indexResponses.put(indexResponse.getIndex(), indexResponse);
        }
        listener.onResponse((Object)new ExplainLifecycleResponse(indexResponses));
    }

    @Nullable
    static IndexLifecycleExplainResponse getIndexLifecycleExplainResponse(String indexName, Metadata metadata, boolean onlyErrors, boolean onlyManaged, IndexLifecycleService indexLifecycleService, NamedXContentRegistry xContentRegistry, boolean rolloverOnlyIfHasDocuments) throws IOException {
        Long originationDate;
        IndexMetadata indexMetadata = metadata.index(indexName);
        Settings idxSettings = indexMetadata.getSettings();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String policyName = indexMetadata.getLifecyclePolicyName();
        String currentPhase = lifecycleState.phase();
        String stepInfo = lifecycleState.stepInfo();
        String previousStepInfo = lifecycleState.previousStepInfo();
        BytesArray stepInfoBytes = null;
        if (stepInfo != null) {
            stepInfoBytes = new BytesArray(stepInfo);
        }
        BytesArray previousStepInfoBytes = null;
        if (previousStepInfo != null) {
            previousStepInfoBytes = new BytesArray(previousStepInfo);
        }
        Long indexCreationDate = indexMetadata.getCreationDate();
        String phaseDef = lifecycleState.phaseDefinition();
        PhaseExecutionInfo phaseExecutionInfo = null;
        if (!Strings.isNullOrEmpty((String)phaseDef)) {
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry), phaseDef);){
                RolloverAction rolloverAction;
                phaseExecutionInfo = PhaseExecutionInfo.parse((XContentParser)parser, (String)currentPhase);
                Phase phase = phaseExecutionInfo.getPhase();
                if (phase != null && (rolloverAction = (RolloverAction)phase.getActions().get("rollover")) != null) {
                    RolloverConditions conditions = WaitForRolloverReadyStep.applyDefaultConditions((RolloverConditions)rolloverAction.getConditions(), (boolean)rolloverOnlyIfHasDocuments);
                    phase.getActions().put("rollover", new RolloverAction(conditions));
                }
            }
        }
        Object indexResponse = metadata.isIndexManagedByILM(indexMetadata) ? (!onlyErrors || "ERROR".equals(lifecycleState.step()) || !indexLifecycleService.policyExists(policyName) ? IndexLifecycleExplainResponse.newManagedIndexResponse((String)indexName, (Long)indexCreationDate, (String)policyName, (Long)((originationDate = idxSettings.getAsLong("index.lifecycle.origination_date", Long.valueOf(-1L))) != -1L ? originationDate : lifecycleState.lifecycleDate()), (String)lifecycleState.phase(), (String)lifecycleState.action(), (String)(!indexLifecycleService.policyExists(policyName) ? "ERROR" : lifecycleState.step()), (String)lifecycleState.failedStep(), (Boolean)lifecycleState.isAutoRetryableError(), (Integer)lifecycleState.failedStepRetryCount(), (Long)lifecycleState.phaseTime(), (Long)lifecycleState.actionTime(), (Long)lifecycleState.stepTime(), (String)lifecycleState.snapshotRepository(), (String)lifecycleState.snapshotName(), (String)lifecycleState.shrinkIndexName(), (BytesReference)stepInfoBytes, (BytesReference)previousStepInfoBytes, (PhaseExecutionInfo)phaseExecutionInfo) : null) : (!onlyManaged && !onlyErrors ? IndexLifecycleExplainResponse.newUnmanagedIndexResponse((String)indexName) : null);
        return indexResponse;
    }
}

