/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ParserConstructor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class ColumnInfoImpl
implements ColumnInfo {
    public static final InstantiatingObjectParser<ColumnInfoImpl, Void> PARSER;
    private String name;
    private DataType type;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ColumnInfoImpl) {
            ColumnInfoImpl that = (ColumnInfoImpl)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public static ColumnInfo fromXContent(XContentParser parser) {
        return (ColumnInfo)PARSER.apply(parser, null);
    }

    @ParserConstructor
    public ColumnInfoImpl(String name, String type) {
        this(name, DataType.fromEs((String)type));
    }

    public ColumnInfoImpl(String name, DataType type) {
        this.name = name;
        this.type = type;
    }

    public ColumnInfoImpl(StreamInput in) throws IOException {
        this(in.readString(), in.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type.outputType());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("type", this.type.outputType());
        builder.endObject();
        return builder;
    }

    public String name() {
        return this.name;
    }

    public String outputType() {
        return this.type.outputType();
    }

    public DataType type() {
        return this.type;
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"esql/column_info", (boolean)true, ColumnInfoImpl.class);
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        PARSER = parser.build();
    }
}

