/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.action.RequestXContent;
import org.elasticsearch.xpack.esql.action.RestEsqlQueryAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestEsqlAsyncQueryAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestEsqlAsyncQueryAction.class);

    public String getName() {
        return "esql_async_query";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_query/async"));
    }

    public Set<String> supportedCapabilities() {
        return EsqlCapabilities.CAPABILITIES;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentOrSourceParamParser();){
            BaseRestHandler.RestChannelConsumer restChannelConsumer = RestEsqlQueryAction.restChannelConsumer(RequestXContent.parseAsync(parser), request, client);
            return restChannelConsumer;
        }
    }

    protected Set<String> responseParams() {
        return Set.of("delimiter", "drop_null_columns");
    }
}

