/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToBoolean
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToBoolean", ToBoolean::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.BOOLEAN, (field, source) -> field), Map.entry(DataType.KEYWORD, ToBooleanFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToBooleanFromStringEvaluator.Factory::new), Map.entry(DataType.SEMANTIC_TEXT, ToBooleanFromStringEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToBooleanFromDoubleEvaluator.Factory::new), Map.entry(DataType.LONG, ToBooleanFromLongEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToBooleanFromUnsignedLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, ToBooleanFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"boolean"}, description="Converts an input value to a boolean value.\nA string value of *true* will be case-insensitive converted to the Boolean *true*.\nFor anything else, including the empty string, the function will return *false*.\nThe numerical value of *0* will be converted to *false*, anything else will be converted to *true*.", examples={@Example(file="boolean", tag="to_boolean")})
    public ToBoolean(Source source, @Param(name="field", type={"boolean", "keyword", "text", "double", "long", "unsigned_long", "integer"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToBoolean(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToBoolean.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToBoolean(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToBoolean::new, (Object)this.field());
    }

    static boolean fromKeyword(BytesRef keyword) {
        return EsqlDataTypeConverter.stringToBoolean(keyword.utf8ToString());
    }

    static boolean fromDouble(double d) {
        return d != 0.0;
    }

    static boolean fromLong(long l) {
        return l != 0L;
    }

    static boolean fromUnsignedLong(long ul) {
        return EsqlDataTypeConverter.unsignedLongToBoolean(ul);
    }

    static boolean fromInt(int i) {
        return ToBoolean.fromLong(i);
    }
}

