/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBigArrayBlock;
import org.elasticsearch.compute.data.DoubleBigArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.LongBigArrayBlock;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.session.Configuration;

public final class PlanStreamOutput
extends StreamOutput
implements org.elasticsearch.xpack.esql.core.util.PlanStreamOutput {
    protected static final int MAX_SERIALIZED_ATTRIBUTES = 1000000;
    private final Map<Block, BytesReference> cachedBlocks = new IdentityHashMap<Block, BytesReference>();
    protected final Map<Attribute, Integer> cachedAttributes = new IdentityHashMap<Attribute, Integer>();
    protected final Map<EsField, Integer> cachedEsFields = new IdentityHashMap<EsField, Integer>();
    protected final Map<String, Integer> stringCache = new HashMap<String, Integer>();
    private final StreamOutput delegate;
    private int nextCachedBlock = 0;
    private final int maxSerializedAttributes;
    static final byte NEW_BLOCK_KEY = 0;
    static final byte FROM_PREVIOUS_KEY = 1;
    static final byte FROM_CONFIG_KEY = 2;

    public PlanStreamOutput(StreamOutput delegate, @Nullable Configuration configuration) throws IOException {
        this(delegate, configuration, 1000000);
    }

    public PlanStreamOutput(StreamOutput delegate, @Nullable Configuration configuration, int maxSerializedAttributes) throws IOException {
        this.delegate = delegate;
        if (configuration != null) {
            for (Map.Entry<String, Map<String, Column>> table : configuration.tables().entrySet()) {
                for (Map.Entry<String, Column> column : table.getValue().entrySet()) {
                    this.cachedBlocks.put(column.getValue().values(), PlanStreamOutput.fromConfigKey(table.getKey(), column.getKey()));
                }
            }
        }
        this.maxSerializedAttributes = maxSerializedAttributes;
    }

    public void writeByte(byte b) throws IOException {
        this.delegate.writeByte(b);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.delegate.writeBytes(b, offset, length);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
        this.stringCache.clear();
        this.cachedEsFields.clear();
        this.cachedAttributes.clear();
    }

    public TransportVersion getTransportVersion() {
        return this.delegate.getTransportVersion();
    }

    public void setTransportVersion(TransportVersion version) {
        this.delegate.setTransportVersion(version);
        super.setTransportVersion(version);
    }

    public void writeCachedBlock(Block block) throws IOException {
        assert (!(block instanceof LongBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof IntBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof DoubleBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof BooleanBigArrayBlock)) : "BigArrays not supported because we don't close";
        BytesReference key = this.cachedBlocks.get(block);
        if (key != null) {
            key.writeTo((OutputStream)((Object)this));
            return;
        }
        this.writeByte((byte)0);
        this.writeVInt(this.nextCachedBlock);
        this.cachedBlocks.put(block, PlanStreamOutput.fromPreviousKey(this.nextCachedBlock));
        this.writeNamedWriteable((NamedWriteable)block);
        ++this.nextCachedBlock;
    }

    public boolean writeAttributeCacheHeader(Attribute attribute) throws IOException {
        if (this.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_2)) {
            Integer cacheId = this.attributeIdFromCache(attribute);
            if (cacheId != null) {
                this.writeZLong(cacheId.intValue());
                return false;
            }
            cacheId = this.cacheAttribute(attribute);
            this.writeZLong(-1 - cacheId);
        }
        return true;
    }

    private Integer attributeIdFromCache(Attribute attr) {
        return this.cachedAttributes.get(attr);
    }

    private int cacheAttribute(Attribute attr) {
        if (this.cachedAttributes.containsKey(attr)) {
            throw new IllegalArgumentException("Attribute already present in the serialization cache [" + String.valueOf(attr) + "]");
        }
        int id = this.cachedAttributes.size();
        if (id >= this.maxSerializedAttributes) {
            throw new InvalidArgumentException("Limit of the number of serialized attributes exceeded [{}]", new Object[]{this.maxSerializedAttributes});
        }
        this.cachedAttributes.put(attr, id);
        return id;
    }

    public boolean writeEsFieldCacheHeader(EsField field) throws IOException {
        if (this.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_2)) {
            Integer cacheId = this.esFieldIdFromCache(field);
            if (cacheId != null) {
                this.writeZLong(cacheId.intValue());
                return false;
            }
            cacheId = this.cacheEsField(field);
            this.writeZLong(-1 - cacheId);
        }
        org.elasticsearch.xpack.esql.core.util.PlanStreamOutput.writeCachedStringWithVersionCheck((StreamOutput)this, (String)field.getWriteableName());
        return true;
    }

    public void writeCachedString(String string) throws IOException {
        Integer cacheId = this.stringCache.get(string);
        if (cacheId != null) {
            this.writeZLong(cacheId.intValue());
            return;
        }
        cacheId = this.stringCache.size();
        if (cacheId >= this.maxSerializedAttributes) {
            throw new InvalidArgumentException("Limit of the number of serialized strings exceeded [{}]", new Object[]{this.maxSerializedAttributes});
        }
        this.stringCache.put(string, cacheId);
        this.writeZLong(-1 - cacheId);
        this.writeString(string);
    }

    public void writeOptionalCachedString(String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeCachedString(str);
        }
    }

    private Integer esFieldIdFromCache(EsField field) {
        return this.cachedEsFields.get(field);
    }

    private int cacheEsField(EsField attr) {
        if (this.cachedEsFields.containsKey(attr)) {
            throw new IllegalArgumentException("EsField already present in the serialization cache [" + String.valueOf(attr) + "]");
        }
        int id = this.cachedEsFields.size();
        if (id >= this.maxSerializedAttributes) {
            throw new InvalidArgumentException("Limit of the number of serialized EsFields exceeded [{}]", new Object[]{this.maxSerializedAttributes});
        }
        this.cachedEsFields.put(attr, id);
        return id;
    }

    static BytesReference fromPreviousKey(int id) throws IOException {
        try (BytesStreamOutput key = new BytesStreamOutput();){
            key.writeByte((byte)1);
            key.writeVInt(id);
            BytesReference bytesReference = key.bytes();
            return bytesReference;
        }
    }

    static BytesReference fromConfigKey(String table, String column) throws IOException {
        try (BytesStreamOutput key = new BytesStreamOutput();){
            key.writeByte((byte)2);
            key.writeString(table);
            key.writeString(column);
            BytesReference bytesReference = key.bytes();
            return bytesReference;
        }
    }
}

