/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.hotthreads;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodeHotThreads
extends BaseNodeResponse {
    private final ReleasableBytesReference bytes;

    NodeHotThreads(StreamInput in) throws IOException {
        super(in);
        this.bytes = in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? in.readReleasableBytesReference() : ReleasableBytesReference.wrap(new BytesArray(in.readString().getBytes(StandardCharsets.UTF_8)));
    }

    public NodeHotThreads(DiscoveryNode node, ReleasableBytesReference hotThreadsUtf8Bytes) {
        super(node);
        assert (hotThreadsUtf8Bytes.hasReferences());
        this.bytes = hotThreadsUtf8Bytes;
    }

    public String getHotThreads() {
        return this.bytes.utf8ToString();
    }

    public Reader getHotThreadsReader() {
        try {
            return new InputStreamReader((InputStream)this.bytes.streamInput(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            assert (false) : e;
            return new StringReader("ERROR:" + e.toString());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            out.writeBytesReference(this.bytes);
        } else {
            out.writeString(this.bytes.utf8ToString());
        }
    }

    @Override
    public void incRef() {
        this.bytes.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.bytes.tryIncRef();
    }

    @Override
    public boolean decRef() {
        return this.bytes.decRef();
    }

    @Override
    public boolean hasReferences() {
        return this.bytes.hasReferences();
    }
}

