/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.verify;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class VerifyRepositoryResponse
extends ActionResponse
implements ToXContentObject {
    static final String NODES = "nodes";
    static final String NAME = "name";
    private List<NodeView> nodes;

    public VerifyRepositoryResponse() {
    }

    public VerifyRepositoryResponse(StreamInput in) throws IOException {
        super(in);
        this.nodes = in.readCollectionAsList(NodeView::new);
    }

    public VerifyRepositoryResponse(DiscoveryNode[] nodes) {
        this.nodes = Arrays.stream(nodes).map(dn -> new NodeView(dn.getId(), dn.getName())).toList();
    }

    public VerifyRepositoryResponse(List<NodeView> nodes) {
        this.nodes = nodes;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.nodes);
    }

    public List<NodeView> getNodes() {
        return this.nodes;
    }

    protected void setNodes(List<NodeView> nodes) {
        this.nodes = nodes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NODES);
        for (NodeView node : this.nodes) {
            node.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyRepositoryResponse that = (VerifyRepositoryResponse)o;
        return Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }

    public static class NodeView
    implements Writeable,
    ToXContentObject {
        final String nodeId;
        String name;

        public NodeView(String nodeId) {
            this.nodeId = nodeId;
        }

        public NodeView(String nodeId, String name) {
            this(nodeId);
            this.name = name;
        }

        public NodeView(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.name);
        }

        void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.nodeId);
            builder.field(VerifyRepositoryResponse.NAME, this.name);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeView other = (NodeView)obj;
            return Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.name);
        }
    }
}

