/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public class SimulateIndexTemplateRequest
extends MasterNodeReadRequest<SimulateIndexTemplateRequest> {
    private String indexName;
    @Nullable
    private TransportPutComposableIndexTemplateAction.Request indexTemplateRequest;
    private boolean includeDefaults = false;

    public SimulateIndexTemplateRequest(String indexName) {
        super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
        if (Strings.isNullOrEmpty(indexName)) {
            throw new IllegalArgumentException("index name cannot be null or empty");
        }
        this.indexName = indexName;
    }

    public SimulateIndexTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.indexName = in.readString();
        this.indexTemplateRequest = in.readOptionalWriteable(TransportPutComposableIndexTemplateAction.Request::new);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            this.includeDefaults = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.indexName);
        out.writeOptionalWriteable(this.indexTemplateRequest);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeBoolean(this.includeDefaults);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexTemplateRequest != null) {
            validationException = this.indexTemplateRequest.validateIndexTemplate(validationException);
        }
        return validationException;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Nullable
    public TransportPutComposableIndexTemplateAction.Request getIndexTemplateRequest() {
        return this.indexTemplateRequest;
    }

    public SimulateIndexTemplateRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public SimulateIndexTemplateRequest indexTemplateRequest(TransportPutComposableIndexTemplateAction.Request indexTemplateRequest) {
        this.indexTemplateRequest = indexTemplateRequest;
        return this;
    }

    public SimulateIndexTemplateRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulateIndexTemplateRequest that = (SimulateIndexTemplateRequest)o;
        return this.indexName.equals(that.indexName) && Objects.equals(this.indexTemplateRequest, that.indexTemplateRequest) && this.includeDefaults == that.includeDefaults;
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.indexTemplateRequest, this.includeDefaults);
    }
}

