/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;

public abstract class SimpleBatchedExecutor<Task extends ClusterStateTaskListener, TaskResult>
implements ClusterStateTaskExecutor<Task> {
    public abstract Tuple<ClusterState, TaskResult> executeTask(Task var1, ClusterState var2) throws Exception;

    public ClusterState afterBatchExecution(ClusterState clusterState, boolean clusterStateChanged) {
        return clusterState;
    }

    public abstract void taskSucceeded(Task var1, TaskResult var2);

    @Override
    public final void clusterStatePublished(ClusterState newClusterState) {
        this.clusterStatePublished();
    }

    public void clusterStatePublished() {
    }

    @Override
    public final ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<Task> batchExecutionContext) throws Exception {
        ClusterState initState;
        ClusterState clusterState = initState = batchExecutionContext.initialState();
        for (ClusterStateTaskExecutor.TaskContext<Task> taskContext : batchExecutionContext.taskContexts()) {
            try {
                Releasable ignored = taskContext.captureResponseHeaders();
                try {
                    Task task = taskContext.getTask();
                    Tuple<ClusterState, TaskResult> result = this.executeTask(task, clusterState);
                    clusterState = (ClusterState)result.v1();
                    Object taskResult = result.v2();
                    taskContext.success(() -> this.taskSucceeded(task, taskResult));
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                taskContext.onFailure(e);
            }
        }
        try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
            ClusterState clusterState2 = this.afterBatchExecution(clusterState, clusterState != initState);
            return clusterState2;
        }
    }
}

