/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class ElectionSchedulerFactory {
    private static final Logger logger = LogManager.getLogger(ElectionSchedulerFactory.class);
    private static final String ELECTION_INITIAL_TIMEOUT_SETTING_KEY = "cluster.election.initial_timeout";
    private static final String ELECTION_BACK_OFF_TIME_SETTING_KEY = "cluster.election.back_off_time";
    private static final String ELECTION_MAX_TIMEOUT_SETTING_KEY = "cluster.election.max_timeout";
    private static final String ELECTION_DURATION_SETTING_KEY = "cluster.election.duration";
    public static final Setting<TimeValue> ELECTION_INITIAL_TIMEOUT_SETTING = Setting.timeSetting("cluster.election.initial_timeout", TimeValue.timeValueMillis((long)100L), TimeValue.timeValueMillis((long)1L), TimeValue.timeValueSeconds((long)10L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> ELECTION_BACK_OFF_TIME_SETTING = Setting.timeSetting("cluster.election.back_off_time", TimeValue.timeValueMillis((long)100L), TimeValue.timeValueMillis((long)1L), TimeValue.timeValueSeconds((long)60L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> ELECTION_MAX_TIMEOUT_SETTING = Setting.timeSetting("cluster.election.max_timeout", TimeValue.timeValueSeconds((long)10L), TimeValue.timeValueMillis((long)200L), TimeValue.timeValueSeconds((long)600L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> ELECTION_DURATION_SETTING = Setting.timeSetting("cluster.election.duration", TimeValue.timeValueMillis((long)500L), TimeValue.timeValueMillis((long)1L), TimeValue.timeValueSeconds((long)600L), Setting.Property.NodeScope);
    private final TimeValue initialTimeout;
    private final TimeValue backoffTime;
    private final TimeValue maxTimeout;
    private final TimeValue duration;
    private final ThreadPool threadPool;
    private final Executor clusterCoordinationExecutor;
    private final Random random;

    public ElectionSchedulerFactory(Settings settings, Random random, ThreadPool threadPool) {
        this.random = random;
        this.threadPool = threadPool;
        this.clusterCoordinationExecutor = threadPool.executor("cluster_coordination");
        this.initialTimeout = ELECTION_INITIAL_TIMEOUT_SETTING.get(settings);
        this.backoffTime = ELECTION_BACK_OFF_TIME_SETTING.get(settings);
        this.maxTimeout = ELECTION_MAX_TIMEOUT_SETTING.get(settings);
        this.duration = ELECTION_DURATION_SETTING.get(settings);
        if (this.maxTimeout.millis() < this.initialTimeout.millis()) {
            throw new IllegalArgumentException(Strings.format((String)"[%s] is [%s], but must be at least [%s] which is [%s]", (Object[])new Object[]{ELECTION_MAX_TIMEOUT_SETTING_KEY, this.maxTimeout, ELECTION_INITIAL_TIMEOUT_SETTING_KEY, this.initialTimeout}));
        }
    }

    public Releasable startElectionScheduler(TimeValue gracePeriod, Runnable scheduledRunnable) {
        ElectionScheduler scheduler = new ElectionScheduler();
        scheduler.scheduleNextElection(gracePeriod, scheduledRunnable);
        return scheduler;
    }

    @SuppressForbidden(reason="Argument to Math.abs() is definitely not Long.MIN_VALUE")
    private static long nonNegative(long n) {
        return n == Long.MIN_VALUE ? 0L : Math.abs(n);
    }

    static long toPositiveLongAtMost(long randomNumber, long upperBound) {
        assert (0L < upperBound) : upperBound;
        return ElectionSchedulerFactory.nonNegative(randomNumber) % upperBound + 1L;
    }

    public String toString() {
        return "ElectionSchedulerFactory{initialTimeout=" + String.valueOf(this.initialTimeout) + ", backoffTime=" + String.valueOf(this.backoffTime) + ", maxTimeout=" + String.valueOf(this.maxTimeout) + "}";
    }

    private class ElectionScheduler
    implements Releasable {
        private final AtomicBoolean isClosed = new AtomicBoolean();
        private final AtomicLong attempt = new AtomicLong();

        private ElectionScheduler() {
        }

        void scheduleNextElection(final TimeValue gracePeriod, final Runnable scheduledRunnable) {
            if (this.isClosed.get()) {
                logger.debug("{} not scheduling election", (Object)this);
                return;
            }
            final long thisAttempt = this.attempt.getAndIncrement();
            final long maxDelayMillis = Math.min(ElectionSchedulerFactory.this.maxTimeout.millis(), ElectionSchedulerFactory.this.initialTimeout.millis() + thisAttempt * ElectionSchedulerFactory.this.backoffTime.millis());
            final long delayMillis = ElectionSchedulerFactory.toPositiveLongAtMost(ElectionSchedulerFactory.this.random.nextLong(), maxDelayMillis) + gracePeriod.millis();
            AbstractRunnable runnable = new AbstractRunnable(){

                @Override
                public void onRejection(Exception e) {
                    logger.debug("threadpool was shut down", (Throwable)e);
                }

                @Override
                public void onFailure(Exception e) {
                    logger.debug(() -> Strings.format((String)"unexpected exception in wakeup of %s", (Object[])new Object[]{this}), (Throwable)e);
                    assert (false) : e;
                }

                @Override
                protected void doRun() {
                    if (ElectionScheduler.this.isClosed.get()) {
                        logger.debug("{} not starting election", (Object)this);
                    } else {
                        logger.debug("{} starting election", (Object)this);
                        if (thisAttempt > 0L && thisAttempt % 10L == 0L) {
                            logger.info("retrying master election after [{}] failed attempts; election attempts are currently scheduled up to [{}ms] apart", (Object)thisAttempt, (Object)maxDelayMillis);
                        }
                        ElectionScheduler.this.scheduleNextElection(ElectionSchedulerFactory.this.duration, scheduledRunnable);
                        scheduledRunnable.run();
                    }
                }

                public String toString() {
                    return "scheduleNextElection{gracePeriod=" + String.valueOf(gracePeriod) + ", thisAttempt=" + thisAttempt + ", maxDelayMillis=" + maxDelayMillis + ", delayMillis=" + delayMillis + ", " + String.valueOf(ElectionScheduler.this) + "}";
                }
            };
            logger.debug("scheduling {}", (Object)runnable);
            ElectionSchedulerFactory.this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueMillis((long)delayMillis), ElectionSchedulerFactory.this.clusterCoordinationExecutor, runnable);
        }

        public String toString() {
            return "ElectionScheduler{attempt=" + String.valueOf(this.attempt) + ",isClosed=" + this.isClosed.get() + "," + String.valueOf(ElectionSchedulerFactory.this) + "}";
        }

        public void close() {
            logger.trace("closing {}", (Object)this);
            boolean wasNotPreviouslyClosed = this.isClosed.compareAndSet(false, true);
            assert (wasNotPreviouslyClosed);
        }
    }
}

