/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination.stateless;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record Heartbeat(long term, long absoluteTimeInMillis) implements Writeable
{
    public Heartbeat(StreamInput in) throws IOException {
        this(in.readLong(), in.readLong());
    }

    long timeSinceLastHeartbeatInMillis(long nowInMillis) {
        return nowInMillis - this.absoluteTimeInMillis;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.term);
        out.writeLong(this.absoluteTimeInMillis);
    }
}

