/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.Booleans;

public record AutoExpandReplicas(int minReplicas, int maxReplicas, boolean enabled) {
    private static final String ALL_NODES_VALUE = "all";
    private static final AutoExpandReplicas FALSE_INSTANCE = new AutoExpandReplicas(0, 0, false);
    public static final Setting<AutoExpandReplicas> SETTING = new Setting<AutoExpandReplicas>("index.auto_expand_replicas", "false", AutoExpandReplicas::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);

    public AutoExpandReplicas {
        if (minReplicas > maxReplicas) {
            throw new IllegalArgumentException("[index.auto_expand_replicas] minReplicas must be =< maxReplicas but wasn't " + minReplicas + " > " + maxReplicas);
        }
    }

    private static AutoExpandReplicas parse(String value) {
        int max;
        int min;
        if (Booleans.isFalse((String)value)) {
            return FALSE_INSTANCE;
        }
        int dash = value.indexOf(45);
        if (-1 == dash) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash);
        }
        String sMin = value.substring(0, dash);
        try {
            min = Integer.parseInt(sMin);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash, e);
        }
        String sMax = value.substring(dash + 1);
        if (sMax.equals(ALL_NODES_VALUE)) {
            max = Integer.MAX_VALUE;
        } else {
            try {
                max = Integer.parseInt(sMax);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash, e);
            }
        }
        return new AutoExpandReplicas(min, max, true);
    }

    public boolean expandToAllNodes() {
        return this.maxReplicas == Integer.MAX_VALUE;
    }

    public int getDesiredNumberOfReplicas(IndexMetadata indexMetadata, RoutingAllocation allocation) {
        assert (this.enabled) : "should only be called when enabled";
        int numMatchingDataNodes = 0;
        for (DiscoveryNode discoveryNode : allocation.nodes().getDataNodes().values()) {
            Decision decision = allocation.deciders().shouldAutoExpandToNode(indexMetadata, discoveryNode, allocation);
            if (decision.type() == Decision.Type.NO) continue;
            ++numMatchingDataNodes;
        }
        return this.calculateDesiredNumberOfReplicas(numMatchingDataNodes);
    }

    int calculateDesiredNumberOfReplicas(int numMatchingDataNodes) {
        int numberOfReplicas = numMatchingDataNodes - 1;
        if (numberOfReplicas < this.minReplicas) {
            numberOfReplicas = this.minReplicas;
        } else if (numberOfReplicas > this.maxReplicas) {
            numberOfReplicas = this.maxReplicas;
        }
        return numberOfReplicas;
    }

    @Override
    public String toString() {
        return this.enabled ? this.minReplicas + "-" + this.maxReplicas : "false";
    }

    public static Map<Integer, List<String>> getAutoExpandReplicaChanges(Metadata metadata, Supplier<RoutingAllocation> allocationSupplier) {
        HashMap<Integer, List<String>> nrReplicasChanged = new HashMap<Integer, List<String>>();
        RoutingAllocation allocation = null;
        for (IndexMetadata indexMetadata : metadata) {
            int numberOfReplicas;
            AutoExpandReplicas autoExpandReplicas;
            if (indexMetadata.getState() != IndexMetadata.State.OPEN && !MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata) || !(autoExpandReplicas = indexMetadata.getAutoExpandReplicas()).enabled()) continue;
            if (Objects.equals(indexMetadata.getSettings().get(ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.getKey()), "stateless")) {
                if (indexMetadata.getNumberOfReplicas() != 0) continue;
                nrReplicasChanged.computeIfAbsent(1, ArrayList::new).add(indexMetadata.getIndex().getName());
            }
            if (allocation == null) {
                allocation = allocationSupplier.get();
            }
            if ((numberOfReplicas = autoExpandReplicas.getDesiredNumberOfReplicas(indexMetadata, allocation)) == indexMetadata.getNumberOfReplicas()) continue;
            nrReplicasChanged.computeIfAbsent(numberOfReplicas, ArrayList::new).add(indexMetadata.getIndex().getName());
        }
        return nrReplicasChanged;
    }
}

