/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.elasticsearch.common.logging.DeprecatedMessage;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.ESLogMessage;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;

public class DeprecationLogger {
    public static Level CRITICAL = Level.forName((String)"CRITICAL", (int)(Level.WARN.intLevel() - 1));
    private static volatile List<String> skipTheseDeprecations = Collections.emptyList();
    private final Logger logger;

    public static DeprecationLogger getLogger(Class<?> aClass) {
        return DeprecationLogger.getLogger(DeprecationLogger.toLoggerName(aClass));
    }

    public static DeprecationLogger getLogger(String name) {
        return new DeprecationLogger(name);
    }

    public static void initialize(Settings nodeSettings) {
        skipTheseDeprecations = nodeSettings == null ? Collections.emptyList() : nodeSettings.getAsList("deprecation.skip_deprecated_settings");
    }

    private DeprecationLogger(String parentLoggerName) {
        this.logger = LogManager.getLogger((String)DeprecationLogger.getLoggerName(parentLoggerName));
    }

    private static String getLoggerName(String name) {
        name = ((String)name).startsWith("org.elasticsearch") ? ((String)name).replace("org.elasticsearch.", "org.elasticsearch.deprecation.") : "deprecation." + (String)name;
        return name;
    }

    private static String toLoggerName(Class<?> cls) {
        String canonicalName = cls.getCanonicalName();
        return canonicalName != null ? canonicalName : cls.getName();
    }

    public DeprecationLogger critical(DeprecationCategory category, String key, String msg, Object ... params) {
        return this.logDeprecation(CRITICAL, category, key, msg, params);
    }

    public DeprecationLogger warn(DeprecationCategory category, String key, String msg, Object ... params) {
        return this.logDeprecation(Level.WARN, category, key, msg, params);
    }

    private DeprecationLogger logDeprecation(Level level, DeprecationCategory category, String key, String msg, Object[] params) {
        if (!Regex.simpleMatch(skipTheseDeprecations, key)) {
            assert (category != DeprecationCategory.COMPATIBLE_API) : "DeprecationCategory.COMPATIBLE_API should be logged with compatibleApiWarning method";
            String opaqueId = HeaderWarning.getXOpaqueId();
            String productOrigin = HeaderWarning.getProductOrigin();
            ESLogMessage deprecationMessage = DeprecatedMessage.of(category, key, opaqueId, productOrigin, msg, params);
            this.doPrivilegedLog(level, deprecationMessage);
        }
        return this;
    }

    private void doPrivilegedLog(Level level, ESLogMessage deprecationMessage) {
        AccessController.doPrivileged(() -> {
            this.logger.log(level, (Message)deprecationMessage);
            return null;
        });
    }

    public DeprecationLogger compatibleCritical(String key, String msg, Object ... params) {
        return this.compatible(CRITICAL, key, msg, params);
    }

    public DeprecationLogger compatible(Level level, String key, String msg, Object ... params) {
        String opaqueId = HeaderWarning.getXOpaqueId();
        String productOrigin = HeaderWarning.getProductOrigin();
        ESLogMessage deprecationMessage = DeprecatedMessage.compatibleDeprecationMessage(key, opaqueId, productOrigin, msg, params);
        this.logger.log(level, (Message)deprecationMessage);
        return this;
    }
}

