/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.IntervalThrottler;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;

public class DocumentMapper {
    static final NodeFeature INDEX_SORTING_ON_NESTED = new NodeFeature("mapper.index_sorting_on_nested", true);
    private final String type;
    private final CompressedXContent mappingSource;
    private final MappingLookup mappingLookup;
    private final DocumentParser documentParser;
    private final MapperMetrics mapperMetrics;
    private final IndexVersion indexVersion;
    private final Logger logger;
    private final String indexName;

    public static DocumentMapper createEmpty(MapperService mapperService) {
        RootObjectMapper root = new RootObjectMapper.Builder("_doc", ObjectMapper.Defaults.SUBOBJECTS).build(MapperBuilderContext.root(false, false));
        MetadataFieldMapper[] metadata = mapperService.getMetadataMappers().values().toArray(new MetadataFieldMapper[0]);
        Mapping mapping = new Mapping(root, metadata, null);
        return new DocumentMapper(mapperService.documentParser(), mapping, mapping.toCompressedXContent(), IndexVersion.current(), mapperService.getMapperMetrics(), mapperService.index().getName());
    }

    DocumentMapper(DocumentParser documentParser, Mapping mapping, CompressedXContent source, IndexVersion version, MapperMetrics mapperMetrics, String indexName) {
        this.documentParser = documentParser;
        this.type = mapping.getRoot().fullPath();
        this.mappingLookup = MappingLookup.fromMapping(mapping);
        this.mappingSource = source;
        this.mapperMetrics = mapperMetrics;
        this.indexVersion = version;
        this.logger = Loggers.getLogger(this.getClass(), indexName);
        this.indexName = indexName;
        assert (mapping.toCompressedXContent().equals(source) || this.isSyntheticSourceMalformed(source, version)) : "provided source [" + String.valueOf(source) + "] differs from mapping [" + String.valueOf(mapping.toCompressedXContent()) + "]";
    }

    private void maybeLog(Exception ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Error while parsing document for index [" + this.indexName + "]: " + ex.getMessage(), (Throwable)ex);
        } else if (IntervalThrottler.DOCUMENT_PARSING_FAILURE.accept()) {
            this.logger.info("Error while parsing document for index [" + this.indexName + "]: " + ex.getMessage(), (Throwable)ex);
        }
    }

    boolean isSyntheticSourceMalformed(CompressedXContent source, IndexVersion version) {
        return this.sourceMapper().isSynthetic() && !source.string().contains("\"_source\":{\"mode\":\"synthetic\"}") && version.onOrBefore(IndexVersions.V_8_10_0);
    }

    public Mapping mapping() {
        return this.mappingLookup.getMapping();
    }

    public String type() {
        return this.type;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping().getMetadataMapperByClass(type);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public MappingLookup mappers() {
        return this.mappingLookup;
    }

    public ParsedDocument parse(SourceToParse source) throws DocumentParsingException {
        try {
            return this.documentParser.parseDocument(source, this.mappingLookup);
        }
        catch (Exception e) {
            this.maybeLog(e);
            throw e;
        }
    }

    public void validate(IndexSettings settings, boolean checkLimits) {
        this.mapping().validate(this.mappingLookup);
        if (settings.getIndexMetadata().isRoutingPartitionedIndex() && !this.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + this.type() + "] must have routing required for partitioned index [" + settings.getIndex().getName() + "]");
        }
        settings.getMode().validateMapping(this.mappingLookup);
        try {
            this.mappingLookup.newSourceLoader(null, this.mapperMetrics.sourceFieldMetrics());
        }
        catch (IllegalArgumentException e) {
            this.mapperMetrics.sourceFieldMetrics().recordSyntheticSourceIncompatibleMapping();
            throw e;
        }
        if (settings.getIndexSortConfig().hasIndexSort() && this.mappers().nestedLookup() != NestedLookup.EMPTY) {
            if (this.indexVersion.before(IndexVersions.INDEX_SORTING_ON_NESTED)) {
                throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
            }
            for (String field : settings.getValue(IndexSortConfig.INDEX_SORT_FIELD_SETTING)) {
                NestedObjectMapper nestedMapper = this.mappers().nestedLookup().getNestedMappers().get(field);
                String nestedParent = nestedMapper != null ? nestedMapper.fullPath() : this.mappers().nestedLookup().getNestedParent(field);
                if (nestedParent == null) continue;
                throw new IllegalArgumentException("cannot apply index sort to field [" + field + "] under nested object [" + nestedParent + "]");
            }
        }
        List<String> routingPaths = settings.getIndexMetadata().getRoutingPaths();
        for (String path : routingPaths) {
            if (settings.getMode() == IndexMode.TIME_SERIES) {
                for (String match : this.mappingLookup.getMatchingFieldNames(path)) {
                    this.mappingLookup.getFieldType(match).validateMatchedRoutingPath(path);
                }
            }
            for (String objectName : this.mappingLookup.objectMappers().keySet()) {
                if (!path.equals(objectName)) continue;
                throw new IllegalArgumentException("All fields that match routing_path must be flattened fields. [" + objectName + "] was [object].");
            }
        }
        if (checkLimits) {
            this.mappingLookup.checkLimits(settings);
        }
    }
}

