/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ingest.Processor;

public abstract class AbstractProcessor
implements Processor {
    protected final String tag;
    protected final String description;

    protected AbstractProcessor(String tag, String description) {
        this.tag = tag;
        this.description = description;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected ElasticsearchException logAndBuildException(String message, Throwable throwable) {
        Object cause = throwable.getClass().getName();
        if (throwable.getMessage() != null) {
            cause = (String)cause + ": " + throwable.getMessage();
        }
        String longMessage = message + ": " + (String)cause;
        Logger logger = LogManager.getLogger(this.getClass());
        if (logger.isTraceEnabled()) {
            logger.trace(message, throwable);
        } else {
            logger.warn(longMessage);
        }
        return new ElasticsearchException(longMessage, new Object[0]);
    }
}

