/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice.internal;

import java.util.List;
import org.elasticsearch.injection.guice.Binder;
import org.elasticsearch.injection.guice.Key;
import org.elasticsearch.injection.guice.internal.BindingImpl;
import org.elasticsearch.injection.guice.internal.Scoping;
import org.elasticsearch.injection.guice.internal.UntargettedBindingImpl;
import org.elasticsearch.injection.guice.spi.Element;
import org.elasticsearch.injection.guice.spi.InstanceBinding;

public abstract class AbstractBindingBuilder<T> {
    public static final String IMPLEMENTATION_ALREADY_SET = "Implementation is set more than once.";
    public static final String SINGLE_INSTANCE_AND_SCOPE = "Setting the scope is not permitted when binding to a single instance.";
    public static final String SCOPE_ALREADY_SET = "Scope is set more than once.";
    public static final String BINDING_TO_NULL = "Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.";
    protected final List<Element> elements;
    protected final int position;
    protected final Binder binder;
    private BindingImpl<T> binding;

    public AbstractBindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        this.binder = binder;
        this.elements = elements;
        this.position = elements.size();
        this.binding = new UntargettedBindingImpl<T>(source, key, Scoping.UNSCOPED);
        elements.add(this.position, this.binding);
    }

    protected BindingImpl<T> getBinding() {
        return this.binding;
    }

    protected BindingImpl<T> setBinding(BindingImpl<T> binding) {
        this.binding = binding;
        this.elements.set(this.position, binding);
        return binding;
    }

    public void asEagerSingleton() {
        this.checkNotScoped();
        this.setBinding(this.getBinding().withEagerSingletonScoping());
    }

    protected void checkNotTargetted() {
        if (!(this.binding instanceof UntargettedBindingImpl)) {
            this.binder.addError(IMPLEMENTATION_ALREADY_SET, new Object[0]);
        }
    }

    protected void checkNotScoped() {
        if (this.binding instanceof InstanceBinding) {
            this.binder.addError(SINGLE_INSTANCE_AND_SCOPE, new Object[0]);
            return;
        }
        if (this.binding.getScoping().isExplicitlyScoped()) {
            this.binder.addError(SCOPE_ALREADY_SET, new Object[0]);
        }
    }
}

