/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.Node;

public class InternalSettingsPreparer {
    public static Environment prepareEnvironment(Settings input, Map<String, String> properties, Path configPath, Supplier<String> defaultNodeName) {
        Path configDir = InternalSettingsPreparer.findConfigDir(configPath, input, properties);
        Path configFile = configDir.resolve("elasticsearch.yml");
        Settings.Builder output = Settings.builder();
        InternalSettingsPreparer.loadConfigWithSubstitutions(output, configFile, System::getenv);
        InternalSettingsPreparer.loadOverrides(output, properties);
        output.put(input);
        InternalSettingsPreparer.replaceForcedSettings(output);
        try {
            output.replacePropertyPlaceholders();
        }
        catch (Exception e) {
            throw new SettingsException("Failed to replace property placeholders from [" + String.valueOf(configFile.getFileName()) + "]", e);
        }
        InternalSettingsPreparer.ensureSpecialSettingsExist(output, defaultNodeName);
        return new Environment(output.build(), configDir);
    }

    static Path findConfigDir(Path configPath, Settings input, Map<String, String> properties) {
        if (configPath != null) {
            return configPath;
        }
        String esHome = properties.get(Environment.PATH_HOME_SETTING.getKey());
        if (esHome == null && (esHome = Environment.PATH_HOME_SETTING.get(input)) == null) {
            throw new IllegalStateException(Environment.PATH_HOME_SETTING.getKey() + " is not configured");
        }
        return InternalSettingsPreparer.resolveConfigDir(esHome);
    }

    @SuppressForbidden(reason="reading initial config")
    private static Path resolveConfigDir(String esHome) {
        return PathUtils.get((String)esHome, (String[])new String[0]).resolve("config");
    }

    static void loadConfigWithSubstitutions(Settings.Builder output, Path configFile, Function<String, String> substitutions) {
        if (!Files.exists(configFile, new LinkOption[0])) {
            return;
        }
        try {
            long existingSize = Files.size(configFile);
            StringBuilder builder = new StringBuilder((int)existingSize);
            try (BufferedReader reader = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
                String line;
                while ((line = reader.readLine()) != null) {
                    int closeNdx;
                    int dollarNdx;
                    int nextNdx = 0;
                    while ((dollarNdx = line.indexOf("${", nextNdx)) != -1 && (closeNdx = line.indexOf(125, dollarNdx + 2)) != -1) {
                        if (dollarNdx > nextNdx) {
                            builder.append(line, nextNdx, dollarNdx);
                        }
                        nextNdx = closeNdx + 1;
                        String substKey = line.substring(dollarNdx + 2, closeNdx);
                        String substValue = substitutions.apply(substKey);
                        if (substValue != null) {
                            builder.append(substValue);
                            continue;
                        }
                        builder.append(line, dollarNdx, nextNdx);
                    }
                    if (nextNdx < line.length()) {
                        builder.append(line, nextNdx, line.length());
                    }
                    builder.append(System.lineSeparator());
                }
            }
            ByteArrayInputStream is = new ByteArrayInputStream(builder.toString().getBytes(StandardCharsets.UTF_8));
            output.loadFromStream(configFile.getFileName().toString(), is, false);
        }
        catch (IOException e) {
            throw new SettingsException("Failed to load settings from " + configFile.toString(), e);
        }
    }

    static void loadOverrides(Settings.Builder output, Map<String, String> overrides) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            builder.append(entry.getKey());
            builder.append(": ");
            builder.append(entry.getValue());
            builder.append(System.lineSeparator());
        }
        ByteArrayInputStream is = new ByteArrayInputStream(builder.toString().getBytes(StandardCharsets.UTF_8));
        try {
            output.loadFromStream("overrides.yml", is, false);
        }
        catch (IOException e) {
            throw new SettingsException("Malformed setting override value", e);
        }
    }

    private static void replaceForcedSettings(Settings.Builder output) {
        ArrayList<String> forcedSettings = new ArrayList<String>();
        for (String setting : output.keys()) {
            if (!setting.startsWith("force.")) continue;
            forcedSettings.add(setting);
        }
        for (String forcedSetting : forcedSettings) {
            String value = output.remove(forcedSetting);
            output.put(forcedSetting.substring("force.".length()), value);
        }
    }

    private static void ensureSpecialSettingsExist(Settings.Builder output, Supplier<String> defaultNodeName) {
        if (output.get(ClusterName.CLUSTER_NAME_SETTING.getKey()) == null) {
            output.put(ClusterName.CLUSTER_NAME_SETTING.getKey(), ClusterName.DEFAULT.value());
        }
        if (output.get(Node.NODE_NAME_SETTING.getKey()) == null) {
            output.put(Node.NODE_NAME_SETTING.getKey(), defaultNodeName.get());
        }
    }
}

