/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.admin.indices.CreateIndexCapabilities;

@ServerlessScope(value=Scope.PUBLIC)
public class RestCreateIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestCreateIndexAction.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in create index requests is deprecated. The parameter will be removed in the next major version.";

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/{index}"));
    }

    @Override
    public String getName() {
        return "create_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CreateIndexRequest createIndexRequest = request.getRestApiVersion() == RestApiVersion.V_7 ? RestCreateIndexAction.prepareRequestV7(request) : RestCreateIndexAction.prepareRequest(request);
        return channel -> client.admin().indices().create(createIndexRequest, new RestToXContentListener<CreateIndexResponse>((RestChannel)channel));
    }

    static CreateIndexRequest prepareRequestV7(RestRequest request) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(request.param("index"));
        if (request.hasParam("include_type_name")) {
            request.param("include_type_name");
            deprecationLogger.compatibleCritical("create_index_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        if (request.hasContent()) {
            Map<String, Object> sourceAsMap = (Map<String, Object>)XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
            sourceAsMap = RestCreateIndexAction.prepareMappingsV7(sourceAsMap, request);
            createIndexRequest.source(sourceAsMap, LoggingDeprecationHandler.INSTANCE);
        }
        createIndexRequest.ackTimeout(RestUtils.getAckTimeout(request));
        createIndexRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        createIndexRequest.waitForActiveShards(ActiveShardCount.parseString(request.param("wait_for_active_shards")));
        return createIndexRequest;
    }

    static Map<String, Object> prepareMappingsV7(Map<String, Object> source, RestRequest request) {
        boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
        Map mappings = (Map)source.get("mappings");
        if (includeTypeName && mappings != null && mappings.size() == 1) {
            HashMap<String, Object> newSource = new HashMap<String, Object>();
            newSource.putAll(source);
            String typeName = (String)mappings.keySet().iterator().next();
            if (!Strings.hasText(typeName)) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            Map typedMappings = (Map)mappings.get(typeName);
            newSource.put("mappings", Collections.singletonMap("_doc", typedMappings));
            return newSource;
        }
        return RestCreateIndexAction.prepareMappings(source);
    }

    static CreateIndexRequest prepareRequest(RestRequest request) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(request.param("index"));
        if (request.hasContent()) {
            Map<String, Object> sourceAsMap = (Map<String, Object>)XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
            sourceAsMap = RestCreateIndexAction.prepareMappings(sourceAsMap);
            createIndexRequest.source(sourceAsMap, LoggingDeprecationHandler.INSTANCE);
        }
        createIndexRequest.ackTimeout(RestUtils.getAckTimeout(request));
        createIndexRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        createIndexRequest.waitForActiveShards(ActiveShardCount.parseString(request.param("wait_for_active_shards")));
        return createIndexRequest;
    }

    static Map<String, Object> prepareMappings(Map<String, Object> source) {
        if (!source.containsKey("mappings") || !(source.get("mappings") instanceof Map)) {
            return source;
        }
        HashMap<String, Object> newSource = new HashMap<String, Object>(source);
        Map mappings = (Map)source.get("mappings");
        if (MapperService.isMappingSourceTyped("_doc", mappings)) {
            throw new IllegalArgumentException("The mapping definition cannot be nested under a type [_doc] unless include_type_name is set to true.");
        }
        newSource.put("mappings", Collections.singletonMap("_doc", mappings));
        return newSource;
    }

    @Override
    public Set<String> supportedCapabilities() {
        return CreateIndexCapabilities.CAPABILITIES;
    }
}

