/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.geogrid.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalGeoGrid<B extends InternalGeoGridBucket>
extends InternalMultiBucketAggregation<InternalGeoGrid<B>, InternalGeoGridBucket>
implements GeoGrid {
    protected final int requiredSize;
    protected final List<InternalGeoGridBucket> buckets;

    protected InternalGeoGrid(String name, int requiredSize, List<InternalGeoGridBucket> buckets, Map<String, Object> metadata) {
        super(name, metadata);
        this.requiredSize = requiredSize;
        this.buckets = buckets;
    }

    protected abstract Writeable.Reader<B> getBucketReader();

    public InternalGeoGrid(StreamInput in) throws IOException {
        super(in);
        this.requiredSize = InternalGeoGrid.readSize(in);
        this.buckets = in.readCollectionAsList(this.getBucketReader());
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalGeoGrid.writeSize(this.requiredSize, out);
        out.writeCollection(this.buckets);
    }

    protected abstract InternalGeoGrid<B> create(String var1, int var2, List<InternalGeoGridBucket> var3, Map<String, Object> var4);

    @Override
    public List<InternalGeoGridBucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext context, final int size) {
        return new AggregatorReducer(){
            final LongObjectPagedHashMap<BucketReducer<InternalGeoGridBucket>> bucketsReducer;
            {
                this.bucketsReducer = new LongObjectPagedHashMap(size, context.bigArrays());
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalGeoGrid grid = (InternalGeoGrid)aggregation;
                for (InternalGeoGridBucket bucket : grid.getBuckets()) {
                    BucketReducer<InternalGeoGridBucket> reducer = this.bucketsReducer.get(bucket.hashAsLong());
                    if (reducer == null) {
                        reducer = new BucketReducer<InternalGeoGridBucket>(bucket, context, size);
                        this.bucketsReducer.put(bucket.hashAsLong(), reducer);
                    }
                    reducer.accept(bucket);
                }
            }

            @Override
            public InternalAggregation get() {
                int size2 = Math.toIntExact(!context.isFinalReduce() ? this.bucketsReducer.size() : Math.min((long)InternalGeoGrid.this.requiredSize, this.bucketsReducer.size()));
                try (BucketPriorityQueue ordered = new BucketPriorityQueue(size2, context.bigArrays(), Function.identity());){
                    this.bucketsReducer.forEach(entry -> {
                        Object bucket = InternalGeoGrid.this.createBucket(entry.key, ((BucketReducer)entry.value).getDocCount(), ((BucketReducer)entry.value).getAggregations());
                        ordered.insertWithOverflow(bucket);
                    });
                    InternalGeoGridBucket[] list = new InternalGeoGridBucket[(int)ordered.size()];
                    for (int i = (int)ordered.size() - 1; i >= 0; --i) {
                        list[i] = (InternalGeoGridBucket)ordered.pop();
                    }
                    context.consumeBucketsAndMaybeBreak(list.length);
                    InternalGeoGrid internalGeoGrid = InternalGeoGrid.this.create(InternalGeoGrid.this.getName(), InternalGeoGrid.this.requiredSize, Arrays.asList(list), InternalGeoGrid.this.getMetadata());
                    return internalGeoGrid;
                }
            }

            @Override
            public void close() {
                this.bucketsReducer.forEach(r -> Releasables.close((Releasable)((Releasable)r.value)));
                Releasables.close(this.bucketsReducer);
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this.create(this.getName(), this.requiredSize, this.buckets.stream().map(b -> this.createBucket(b.hashAsLong, samplingContext.scaleUp(b.docCount), InternalAggregations.finalizeSampling(b.aggregations, samplingContext))).toList(), this.getMetadata());
    }

    protected abstract B createBucket(long var1, long var3, InternalAggregations var5);

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (InternalGeoGridBucket bucket : this.buckets) {
            bucket.bucketToXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    int getRequiredSize() {
        return this.requiredSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.requiredSize, this.buckets);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoGrid other = (InternalGeoGrid)obj;
        return Objects.equals(this.requiredSize, other.requiredSize) && Objects.equals(this.buckets, other.buckets);
    }
}

