/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class ReverseNestedAggregatorFactory
extends AggregatorFactory {
    private final boolean unmapped;
    private final NestedObjectMapper parentObjectMapper;

    public ReverseNestedAggregatorFactory(String name, boolean unmapped, NestedObjectMapper parentObjectMapper, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        this.unmapped = unmapped;
        this.parentObjectMapper = parentObjectMapper;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (this.unmapped) {
            return new Unmapped(this.name, this.context, parent, this.factories, metadata);
        }
        return new ReverseNestedAggregator(this.name, this.factories, this.parentObjectMapper, this.context, parent, cardinality, metadata);
    }

    private static final class Unmapped
    extends NonCollectingAggregator {
        Unmapped(String name, AggregationContext context, Aggregator parent, AggregatorFactories factories, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
        }
    }
}

