/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.NestedUtils;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.UnmappedFieldFetcher;
import org.elasticsearch.search.lookup.Source;

public class FieldFetcher {
    private final Map<String, FieldContext> fieldContexts;
    private final UnmappedFieldFetcher unmappedFieldFetcher;
    private final StoredFieldsSpec storedFieldsSpec;

    public static FieldFetcher create(SearchExecutionContext context, Collection<FieldAndFormat> fieldAndFormats) {
        ArrayList<String> unmappedFetchPattern = new ArrayList<String>();
        ArrayList<ResolvedField> resolvedFields = new ArrayList<ResolvedField>();
        for (FieldAndFormat fieldAndFormat : fieldAndFormats) {
            String matchingPattern;
            String fieldPattern = fieldAndFormat.field;
            String string = matchingPattern = Regex.isSimpleMatchPattern(fieldPattern) ? fieldPattern : null;
            if (fieldAndFormat.includeUnmapped != null && fieldAndFormat.includeUnmapped.booleanValue()) {
                unmappedFetchPattern.add(fieldAndFormat.field);
            }
            for (String field : context.getMatchingFieldNames(fieldPattern)) {
                MappedFieldType ft = context.getFieldType(field);
                if (context.isMetadataField(field) && matchingPattern != null) continue;
                resolvedFields.add(new ResolvedField(field, matchingPattern, ft, fieldAndFormat.format));
            }
        }
        resolvedFields.sort(Comparator.comparing(f -> f.field));
        Map<String, FieldContext> fieldContexts = FieldFetcher.buildFieldContexts(context, "", resolvedFields, unmappedFetchPattern);
        UnmappedFieldFetcher unmappedFieldFetcher = FieldFetcher.buildUnmappedFieldFetcher(context, fieldContexts.keySet(), "", unmappedFetchPattern);
        return new FieldFetcher(fieldContexts, unmappedFieldFetcher);
    }

    private static UnmappedFieldFetcher buildUnmappedFieldFetcher(SearchExecutionContext context, Set<String> mappedFields, String nestedScope, List<String> unmappedFetchPatterns) {
        if (unmappedFetchPatterns.isEmpty()) {
            return UnmappedFieldFetcher.EMPTY;
        }
        return new UnmappedFieldFetcher(mappedFields, context.nestedLookup().getImmediateChildMappers(nestedScope), unmappedFetchPatterns);
    }

    private static ValueFetcher buildValueFetcher(SearchExecutionContext context, ResolvedField fieldAndFormat) {
        try {
            return fieldAndFormat.ft.valueFetcher(context, fieldAndFormat.format);
        }
        catch (IllegalArgumentException e) {
            StringBuilder error = new StringBuilder("error fetching [").append(fieldAndFormat.field).append(']');
            if (fieldAndFormat.matchingPattern != null) {
                error.append(" which matched [").append(fieldAndFormat.matchingPattern).append(']');
            }
            error.append(": ").append(e.getMessage());
            throw new IllegalArgumentException(error.toString(), e);
        }
    }

    private static Map<String, FieldContext> buildFieldContexts(SearchExecutionContext context, String nestedScope, List<ResolvedField> fields, List<String> unmappedFetchPatterns) {
        boolean includeUnmapped = !unmappedFetchPatterns.isEmpty();
        Map<String, List<ResolvedField>> fieldsByNestedMapper = NestedUtils.partitionByChildren(nestedScope, context.nestedLookup().getImmediateChildMappers(nestedScope), fields, f -> f.field);
        LinkedHashMap<String, FieldContext> output = new LinkedHashMap<String, FieldContext>();
        for (String scope : fieldsByNestedMapper.keySet()) {
            if (nestedScope.equals(scope)) {
                for (ResolvedField ff : fieldsByNestedMapper.get(nestedScope)) {
                    output.put(ff.field, new FieldContext(ff.field, FieldFetcher.buildValueFetcher(context, ff)));
                }
                continue;
            }
            if (!includeUnmapped && fieldsByNestedMapper.get(scope).isEmpty()) continue;
            Map<String, FieldContext> scopedFields = FieldFetcher.buildFieldContexts(context, scope, fieldsByNestedMapper.get(scope), unmappedFetchPatterns);
            UnmappedFieldFetcher unmappedFieldFetcher = FieldFetcher.buildUnmappedFieldFetcher(context, scopedFields.keySet(), scope, unmappedFetchPatterns);
            NestedValueFetcher nvf = new NestedValueFetcher(scope, new FieldFetcher(scopedFields, unmappedFieldFetcher));
            output.put(scope, new FieldContext(scope, nvf));
        }
        return output;
    }

    private FieldFetcher(Map<String, FieldContext> fieldContexts, UnmappedFieldFetcher unmappedFieldFetcher) {
        this.fieldContexts = fieldContexts;
        this.unmappedFieldFetcher = unmappedFieldFetcher;
        this.storedFieldsSpec = StoredFieldsSpec.build(fieldContexts.values(), fc -> fc.valueFetcher.storedFieldsSpec());
    }

    public StoredFieldsSpec storedFieldsSpec() {
        return this.storedFieldsSpec;
    }

    public Map<String, DocumentField> fetch(Source source, int doc) throws IOException {
        HashMap<String, DocumentField> documentFields = new HashMap<String, DocumentField>();
        for (FieldContext context : this.fieldContexts.values()) {
            ValueFetcher valueFetcher = context.valueFetcher;
            String field = context.fieldName;
            DocumentField docField = valueFetcher.fetchDocumentField(field, source, doc);
            if (docField == null) continue;
            documentFields.put(field, docField);
        }
        this.unmappedFieldFetcher.collectUnmapped(documentFields, source);
        return documentFields;
    }

    public void setNextReader(LeafReaderContext readerContext) {
        for (FieldContext field : this.fieldContexts.values()) {
            field.valueFetcher.setNextReader(readerContext);
        }
    }

    private record ResolvedField(String field, String matchingPattern, MappedFieldType ft, String format) {
    }

    private record FieldContext(String fieldName, ValueFetcher valueFetcher) {
    }
}

