/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractLongScriptFieldQuery;

public class LongScriptFieldTermsQuery
extends AbstractLongScriptFieldQuery {
    private final Set<Long> terms;

    public LongScriptFieldTermsQuery(Script script, Function<LeafReaderContext, AbstractLongFieldScript> leafFactory, String fieldName, Set<Long> terms) {
        super(script, leafFactory, fieldName);
        this.terms = terms;
    }

    @Override
    protected boolean matches(long[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (!this.terms.contains(values[i])) continue;
            return true;
        }
        return false;
    }

    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return this.terms.toString();
        }
        return this.fieldName() + ":" + String.valueOf(this.terms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.terms);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LongScriptFieldTermsQuery other = (LongScriptFieldTermsQuery)((Object)obj);
        return this.terms.equals(other.terms);
    }

    Set<Long> terms() {
        return this.terms;
    }
}

