/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldQuery;

public class StringScriptFieldTermQuery
extends AbstractStringScriptFieldQuery {
    private final String term;
    private final boolean caseInsensitive;

    public StringScriptFieldTermQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, String term, boolean caseInsensitive) {
        super(script, leafFactory, fieldName);
        this.term = Objects.requireNonNull(term);
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    protected boolean matches(List<String> values) {
        for (String value : values) {
            if (!(this.caseInsensitive ? this.term.equalsIgnoreCase(value) : this.term.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.consumeTerms((Query)this, new Term[]{new Term(this.fieldName(), this.term)});
    }

    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return this.term;
        }
        return this.fieldName() + ":" + this.term;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.term, this.caseInsensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        StringScriptFieldTermQuery other = (StringScriptFieldTermQuery)((Object)obj);
        return this.term.equals(other.term) && this.caseInsensitive == other.caseInsensitive;
    }

    String term() {
        return this.term;
    }

    boolean caseInsensitive() {
        return this.caseInsensitive;
    }
}

