/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.options.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.datastreams.options.action.PutDataStreamOptionsAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutDataStreamOptionsAction
extends BaseRestHandler {
    public String getName() {
        return "put_data_stream_options_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_data_stream/{name}/_options"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            PutDataStreamOptionsAction.Request putOptionsRequest = PutDataStreamOptionsAction.Request.parseRequest(parser, failureStore -> new PutDataStreamOptionsAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)request), RestUtils.getAckTimeout((RestRequest)request), Strings.splitStringByCommaToArray((String)request.param("name")), failureStore));
            putOptionsRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)putOptionsRequest.indicesOptions()));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute(PutDataStreamOptionsAction.INSTANCE, (ActionRequest)putOptionsRequest, (ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }
}

