/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonPipe;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Comparisons;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class BinaryComparison
extends BinaryOperator<Object, Object, Boolean, BinaryComparisonProcessor.BinaryComparisonOperation> {
    private final ZoneId zoneId;

    protected BinaryComparison(Source source, Expression left, Expression right, BinaryComparisonProcessor.BinaryComparisonOperation operation, ZoneId zoneId) {
        super(source, left, right, operation);
        this.zoneId = zoneId;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isExact(e, this.sourceText(), paramOrdinal);
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryComparisonPipe(this.source(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()), (BinaryComparisonProcessor.BinaryComparisonOperation)this.function());
    }

    public static Integer compare(Object left, Object right) {
        return Comparisons.compare(left, right);
    }

    public abstract BinaryComparison reverse();
}

