/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.encoding;

public enum GeomCmd {
    MoveTo(1, 2),
    LineTo(2, 2),
    ClosePath(7, 0);

    private final int cmdId;
    private final int paramCount;

    private GeomCmd(int cmdId, int paramCount) {
        this.cmdId = cmdId;
        this.paramCount = paramCount;
    }

    public int getCmdId() {
        return this.cmdId;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public static GeomCmd fromId(int cmdId) {
        GeomCmd geomCmd;
        switch (cmdId) {
            case 1: {
                geomCmd = MoveTo;
                break;
            }
            case 2: {
                geomCmd = LineTo;
                break;
            }
            case 7: {
                geomCmd = ClosePath;
                break;
            }
            default: {
                geomCmd = null;
            }
        }
        return geomCmd;
    }
}

