/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.xpack.sql.client.StringUtils;

public final class UriUtils {
    static final String HTTP_SCHEME = "http";
    static final String HTTPS_SCHEME = "https";
    static final String HTTP_PREFIX = "http://";
    static final String HTTPS_PREFIX = "https://";

    private UriUtils() {
    }

    public static URI parseURI(String connectionString, URI defaultURI) {
        URI uri = UriUtils.parseMaybeWithScheme(connectionString, defaultURI.getScheme() + "://");
        String scheme = uri.getScheme() != null ? uri.getScheme() : defaultURI.getScheme();
        String host = uri.getHost() != null ? uri.getHost() : defaultURI.getHost();
        String path = "".equals(uri.getPath()) ? defaultURI.getPath() : uri.getPath();
        String rawQuery = uri.getQuery() == null ? defaultURI.getRawQuery() : uri.getRawQuery();
        String rawFragment = uri.getFragment() == null ? defaultURI.getRawFragment() : uri.getRawFragment();
        int port = uri.getPort() < 0 ? defaultURI.getPort() : uri.getPort();
        try {
            String connStr = new URI(scheme, uri.getUserInfo(), host, port, path, null, null).toString();
            if (StringUtils.hasLength(rawQuery)) {
                connStr = connStr + "?" + rawQuery;
            }
            if (StringUtils.hasLength(rawFragment)) {
                connStr = connStr + "#" + rawFragment;
            }
            return new URI(connStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid connection configuration [" + connectionString + "]: " + e.getMessage(), e);
        }
    }

    private static URI parseMaybeWithScheme(String connectionString, String defaultPrefix) {
        URI uri;
        String c = connectionString.toLowerCase(Locale.ROOT);
        boolean hasAnHttpPrefix = c.startsWith(HTTP_PREFIX) || c.startsWith(HTTPS_PREFIX);
        try {
            uri = new URI(connectionString);
        }
        catch (URISyntaxException e) {
            if (!hasAnHttpPrefix) {
                return UriUtils.parseMaybeWithScheme(defaultPrefix + connectionString, null);
            }
            URISyntaxException s = CredentialsRedaction.redactedURISyntaxException(e);
            throw new IllegalArgumentException("Invalid connection configuration: " + s.getMessage(), s);
        }
        if (!hasAnHttpPrefix) {
            if (uri.getHost() != null) {
                throw new IllegalArgumentException("Invalid connection scheme [" + uri.getScheme() + "] configuration: only " + HTTP_SCHEME + " and " + HTTPS_SCHEME + " protocols are supported");
            }
            if (connectionString.length() > 0) {
                return UriUtils.parseMaybeWithScheme(defaultPrefix + connectionString, null);
            }
        }
        return uri;
    }

    public static URI removeQuery(URI uri, String connectionString, URI defaultURI) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, defaultURI.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid connection configuration [" + connectionString + "]: " + e.getMessage(), e);
        }
    }

    public static URI appendSegmentToPath(URI uri, String segment) {
        String cleanSegment;
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (segment == null || segment.isEmpty() || "/".equals(segment)) {
            return uri;
        }
        String path = uri.getPath();
        String concatenatedPath = "";
        String string = cleanSegment = segment.startsWith("/") ? segment.substring(1) : segment;
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        concatenatedPath = path.charAt(path.length() - 1) == '/' ? path + cleanSegment : path + "/" + cleanSegment;
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), concatenatedPath, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid segment [" + segment + "] for URI [" + uri + "]: " + e.getMessage(), e);
        }
    }

    public static class CredentialsRedaction {
        public static final Character REDACTION_CHAR = Character.valueOf('*');
        private static final String USER_ATTR_NAME = "user";
        private static final String PASS_ATTR_NAME = "password";

        private static String redactAttributeInString(String string, String attrName, Character replacement) {
            String needle = attrName + "=";
            int attrIdx = string.toLowerCase(Locale.ROOT).indexOf(needle);
            if (attrIdx >= 0) {
                int attrEndIdx = attrIdx + needle.length();
                return string.substring(0, attrEndIdx) + StringUtils.repeatString(String.valueOf(replacement), string.length() - attrEndIdx);
            }
            return string;
        }

        private static void redactValueForSimilarKey(String key, List<String> options, List<Map.Entry<String, String>> attrs, Character replacement) {
            List<String> similar = StringUtils.findSimilar(key, options);
            for (String k : similar) {
                for (Map.Entry<String, String> e : attrs) {
                    if (!e.getKey().equals(k)) continue;
                    e.setValue(StringUtils.repeatString(String.valueOf(replacement), e.getValue().length()));
                }
            }
        }

        public static String redactCredentialsInRawUriQuery(String rawQuery, Character replacement) {
            ArrayList<Map.Entry<String, String>> attrs = new ArrayList<Map.Entry<String, String>>();
            ArrayList<String> options = new ArrayList<String>();
            for (String param : StringUtils.tokenize(rawQuery, "&")) {
                String key;
                String value;
                int n = param.indexOf(61);
                if (n <= 0) {
                    value = n < 0 ? null : "";
                    key = CredentialsRedaction.redactAttributeInString(param, USER_ATTR_NAME, replacement);
                    key = CredentialsRedaction.redactAttributeInString(key, PASS_ATTR_NAME, replacement);
                } else {
                    key = param.substring(0, n);
                    value = param.substring(n + 1);
                    if (value.indexOf(61) >= 0) {
                        value = CredentialsRedaction.redactAttributeInString(value, USER_ATTR_NAME, replacement);
                        value = CredentialsRedaction.redactAttributeInString(value, PASS_ATTR_NAME, replacement);
                    }
                    options.add(key);
                }
                attrs.add(new AbstractMap.SimpleEntry<String, String>(key, value));
            }
            CredentialsRedaction.redactValueForSimilarKey(USER_ATTR_NAME, options, attrs, replacement);
            CredentialsRedaction.redactValueForSimilarKey(PASS_ATTR_NAME, options, attrs, replacement);
            StringBuilder sb = new StringBuilder(rawQuery.length());
            for (Map.Entry entry : attrs) {
                sb.append("&");
                sb.append((String)entry.getKey());
                if (entry.getValue() == null) continue;
                sb.append("=");
                sb.append((String)entry.getValue());
            }
            return sb.substring(1);
        }

        private static String editURI(URI uri, List<Map.Entry<Integer, Character>> faults, boolean hasPort) {
            StringBuilder sb = new StringBuilder();
            if (uri.getScheme() != null) {
                sb.append(uri.getScheme());
                sb.append("://");
            }
            if (uri.getRawUserInfo() != null) {
                sb.append(StringUtils.repeatString("\u0000", uri.getRawUserInfo().length()));
                if (uri.getHost() != null) {
                    sb.append('@');
                }
            }
            if (uri.getHost() != null) {
                sb.append(uri.getHost());
            }
            if (hasPort || uri.getPort() > 0) {
                sb.append(':');
            }
            if (uri.getPort() > 0) {
                sb.append(uri.getPort());
            }
            if (uri.getRawPath() != null) {
                sb.append(uri.getRawPath());
            }
            if (uri.getQuery() != null) {
                sb.append('?');
                sb.append(CredentialsRedaction.redactCredentialsInRawUriQuery(uri.getRawQuery(), Character.valueOf('\u0000')));
            }
            if (uri.getRawFragment() != null) {
                sb.append('#');
                sb.append(uri.getRawFragment());
            }
            Collections.reverse(faults);
            for (Map.Entry<Integer, Character> e : faults) {
                int idx = e.getKey();
                if (idx >= sb.length()) {
                    sb.append(e.getValue());
                    continue;
                }
                sb.insert(idx, sb.charAt(idx) == '\u0000' && (idx + 1 >= sb.length() || sb.charAt(idx + 1) == '\u0000') ? (char)'\u0000' : e.getValue().charValue());
            }
            StringBuilder ret = new StringBuilder();
            sb.chars().forEach(x -> ret.append(x == 0 ? REDACTION_CHAR.charValue() : (char)x));
            return ret.toString();
        }

        private static String redactCredentialsInURLString(String urlString) {
            ArrayList<Map.Entry<Integer, Character>> faults = new ArrayList<Map.Entry<Integer, Character>>();
            boolean hasPort = false;
            StringBuilder sb = new StringBuilder(urlString);
            while (sb.length() > 0) {
                try {
                    URI uri = new URI(sb.toString()).parseServerAuthority();
                    return CredentialsRedaction.editURI(uri, faults, hasPort);
                }
                catch (URISyntaxException use) {
                    int idx = use.getIndex();
                    if (idx < 0 || idx >= sb.length()) break;
                    if (use.getReason().equals("Illegal character in port number")) {
                        hasPort = true;
                    }
                    faults.add(new AbstractMap.SimpleImmutableEntry<Integer, Character>(use.getIndex(), Character.valueOf(sb.charAt(idx))));
                    sb.deleteCharAt(idx);
                }
            }
            return null;
        }

        public static String redactCredentialsInConnectionString(String connectionString) {
            if (connectionString.startsWith(UriUtils.HTTP_PREFIX.toUpperCase(Locale.ROOT)) || connectionString.startsWith(UriUtils.HTTPS_PREFIX.toUpperCase(Locale.ROOT)) || connectionString.length() < "_:_@_".length() || connectionString.indexOf(64) < 0 && connectionString.indexOf(63) < 0) {
                return connectionString;
            }
            String cs = connectionString.toLowerCase(Locale.ROOT);
            boolean prefixed = cs.startsWith(UriUtils.HTTP_PREFIX) || cs.startsWith(UriUtils.HTTPS_PREFIX);
            String redacted = CredentialsRedaction.redactCredentialsInURLString((prefixed ? "" : UriUtils.HTTP_PREFIX) + connectionString);
            if (redacted == null) {
                return "<REDACTED> ; a capitalized scheme (HTTP|HTTPS) disables the redaction";
            }
            return prefixed ? redacted : redacted.substring(UriUtils.HTTP_PREFIX.length());
        }

        public static URISyntaxException redactedURISyntaxException(URISyntaxException e) {
            return new URISyntaxException(CredentialsRedaction.redactCredentialsInConnectionString(e.getInput()), e.getReason(), e.getIndex());
        }
    }
}

